/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.pipeline;

import io.skylite.SkyliteParseException;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.metrics.OperationMetrics;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.search.pipeline.Pipeline;
import io.skylite.core.search.pipeline.SearchPhaseResultsProcessor;
import io.skylite.core.search.pipeline.SearchPipelineStats;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.core.search.pipeline.SearchResponseProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;

class PipelineWithMetrics
extends Pipeline {
    private final OperationMetrics totalRequestMetrics;
    private final OperationMetrics totalResponseMetrics;
    private final OperationMetrics pipelineRequestMetrics = new OperationMetrics();
    private final OperationMetrics pipelineResponseMetrics = new OperationMetrics();
    private final Map<String, OperationMetrics> requestProcessorMetrics = new HashMap<String, OperationMetrics>();
    private final Map<String, OperationMetrics> responseProcessorMetrics = new HashMap<String, OperationMetrics>();

    PipelineWithMetrics(String id, String description, Integer version, List<SearchRequestProcessor> requestProcessors, List<SearchResponseProcessor> responseProcessors, List<SearchPhaseResultsProcessor> phaseResultsProcessors, NamedWriteableRegistry namedWriteableRegistry, OperationMetrics totalRequestMetrics, OperationMetrics totalResponseMetrics, LongSupplier relativeTimeSupplier) {
        super(id, description, version, requestProcessors, responseProcessors, phaseResultsProcessors, namedWriteableRegistry, relativeTimeSupplier);
        this.totalRequestMetrics = totalRequestMetrics;
        this.totalResponseMetrics = totalResponseMetrics;
        for (SearchProcessor searchProcessor : this.getSearchRequestProcessors()) {
            this.requestProcessorMetrics.putIfAbsent(PipelineWithMetrics.getProcessorKey(searchProcessor), new OperationMetrics());
        }
        for (SearchProcessor searchProcessor : this.getSearchResponseProcessors()) {
            this.responseProcessorMetrics.putIfAbsent(PipelineWithMetrics.getProcessorKey(searchProcessor), new OperationMetrics());
        }
    }

    static PipelineWithMetrics create(String id, Map<String, Object> config, Map<String, SearchProcessor.Factory<SearchRequestProcessor>> requestProcessorFactories, Map<String, SearchProcessor.Factory<SearchResponseProcessor>> responseProcessorFactories, Map<String, SearchProcessor.Factory<SearchPhaseResultsProcessor>> phaseResultsProcessorFactories, NamedWriteableRegistry namedWriteableRegistry, OperationMetrics totalRequestProcessingMetrics, OperationMetrics totalResponseProcessingMetrics, SearchProcessor.PipelineContext pipelineContext) throws Exception {
        String description = ConfigurationUtils.readOptionalStringProperty(null, null, config, "description");
        Integer version = ConfigurationUtils.readIntProperty(null, null, config, "version", null);
        List<Map<String, Object>> requestProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, "request_processors");
        List<SearchRequestProcessor> requestProcessors = PipelineWithMetrics.readProcessors(requestProcessorFactories, requestProcessorConfigs, pipelineContext);
        List<Map<String, Object>> responseProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, "response_processors");
        List<SearchResponseProcessor> responseProcessors = PipelineWithMetrics.readProcessors(responseProcessorFactories, responseProcessorConfigs, pipelineContext);
        List<Map<String, Object>> phaseResultsProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, "phase_results_processors");
        List<SearchPhaseResultsProcessor> phaseResultsProcessors = PipelineWithMetrics.readProcessors(phaseResultsProcessorFactories, phaseResultsProcessorConfigs, pipelineContext);
        if (!config.isEmpty()) {
            throw new SkyliteParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters " + Arrays.toString(config.keySet().toArray()), new Object[0]);
        }
        return new PipelineWithMetrics(id, description, version, requestProcessors, responseProcessors, phaseResultsProcessors, namedWriteableRegistry, totalRequestProcessingMetrics, totalResponseProcessingMetrics, System::nanoTime);
    }

    private static <T extends SearchProcessor> List<T> readProcessors(Map<String, SearchProcessor.Factory<T>> processorFactories, List<Map<String, Object>> requestProcessorConfigs, SearchProcessor.PipelineContext pipelineContext) throws Exception {
        ArrayList<SearchProcessor> processors = new ArrayList<SearchProcessor>();
        if (requestProcessorConfigs == null) {
            return processors;
        }
        for (Map<String, Object> processorConfigWithKey : requestProcessorConfigs) {
            for (Map.Entry<String, Object> entry : processorConfigWithKey.entrySet()) {
                String type = entry.getKey();
                if (!processorFactories.containsKey(type)) {
                    throw new IllegalArgumentException("Invalid processor type " + type);
                }
                Map config = (Map)entry.getValue();
                String tag = ConfigurationUtils.readOptionalStringProperty(null, null, config, "tag");
                boolean ignoreFailure = ConfigurationUtils.readBooleanProperty(null, null, config, "ignore_failure", false);
                String description = ConfigurationUtils.readOptionalStringProperty(null, tag, config, "description");
                processors.add((SearchProcessor)processorFactories.get(type).create(processorFactories, tag, description, ignoreFailure, config, pipelineContext));
                if (config.isEmpty()) continue;
                Object processorName = type;
                if (tag != null) {
                    processorName = (String)processorName + ":" + tag;
                }
                throw new SkyliteParseException("processor [" + (String)processorName + "] doesn't support one or more provided configuration parameters: " + Arrays.toString(config.keySet().toArray()), new Object[0]);
            }
        }
        return Collections.unmodifiableList(processors);
    }

    @Override
    protected void beforeTransformRequest() {
        super.beforeTransformRequest();
        this.totalRequestMetrics.before();
        this.pipelineRequestMetrics.before();
    }

    @Override
    protected void afterTransformRequest(long timeInNanos) {
        super.afterTransformRequest(timeInNanos);
        this.totalRequestMetrics.after(timeInNanos);
        this.pipelineRequestMetrics.after(timeInNanos);
    }

    @Override
    protected void onTransformRequestFailure() {
        super.onTransformRequestFailure();
        this.totalRequestMetrics.failed();
        this.pipelineRequestMetrics.failed();
    }

    @Override
    protected void beforeRequestProcessor(SearchProcessor processor) {
        this.requestProcessorMetrics.get(PipelineWithMetrics.getProcessorKey(processor)).before();
    }

    @Override
    protected void afterRequestProcessor(SearchProcessor processor, long timeInNanos) {
        this.requestProcessorMetrics.get(PipelineWithMetrics.getProcessorKey(processor)).after(timeInNanos);
    }

    @Override
    protected void onRequestProcessorFailed(SearchProcessor processor) {
        this.requestProcessorMetrics.get(PipelineWithMetrics.getProcessorKey(processor)).failed();
    }

    @Override
    protected void beforeTransformResponse() {
        super.beforeTransformRequest();
        this.totalResponseMetrics.before();
        this.pipelineResponseMetrics.before();
    }

    @Override
    protected void afterTransformResponse(long timeInNanos) {
        super.afterTransformResponse(timeInNanos);
        this.totalResponseMetrics.after(timeInNanos);
        this.pipelineResponseMetrics.after(timeInNanos);
    }

    @Override
    protected void onTransformResponseFailure() {
        super.onTransformResponseFailure();
        this.totalResponseMetrics.failed();
        this.pipelineResponseMetrics.failed();
    }

    @Override
    protected void beforeResponseProcessor(SearchProcessor processor) {
        this.responseProcessorMetrics.get(PipelineWithMetrics.getProcessorKey(processor)).before();
    }

    @Override
    protected void afterResponseProcessor(SearchProcessor processor, long timeInNanos) {
        this.responseProcessorMetrics.get(PipelineWithMetrics.getProcessorKey(processor)).after(timeInNanos);
    }

    @Override
    protected void onResponseProcessorFailed(SearchProcessor processor) {
        this.responseProcessorMetrics.get(PipelineWithMetrics.getProcessorKey(processor)).failed();
    }

    void copyMetrics(PipelineWithMetrics oldPipeline) {
        this.pipelineRequestMetrics.add(oldPipeline.pipelineRequestMetrics);
        this.pipelineResponseMetrics.add(oldPipeline.pipelineResponseMetrics);
        PipelineWithMetrics.copyProcessorMetrics(this.requestProcessorMetrics, oldPipeline.requestProcessorMetrics);
        PipelineWithMetrics.copyProcessorMetrics(this.responseProcessorMetrics, oldPipeline.responseProcessorMetrics);
    }

    private static <T extends SearchProcessor> void copyProcessorMetrics(Map<String, OperationMetrics> newProcessorMetrics, Map<String, OperationMetrics> oldProcessorMetrics) {
        for (Map.Entry<String, OperationMetrics> oldProcessorMetric : oldProcessorMetrics.entrySet()) {
            if (!newProcessorMetrics.containsKey(oldProcessorMetric.getKey())) continue;
            newProcessorMetrics.get(oldProcessorMetric.getKey()).add(oldProcessorMetric.getValue());
        }
    }

    private static String getProcessorKey(SearchProcessor processor) {
        String key = processor.getType();
        if (processor.getTag() != null) {
            return key + ":" + processor.getTag();
        }
        return key;
    }

    void populateStats(SearchPipelineStats.Builder statsBuilder) {
        String key;
        statsBuilder.addPipelineStats(this.getId(), this.pipelineRequestMetrics, this.pipelineResponseMetrics);
        for (SearchProcessor searchProcessor : this.getSearchRequestProcessors()) {
            key = PipelineWithMetrics.getProcessorKey(searchProcessor);
            statsBuilder.addRequestProcessorStats(this.getId(), key, searchProcessor.getType(), this.requestProcessorMetrics.get(key));
        }
        for (SearchProcessor searchProcessor : this.getSearchResponseProcessors()) {
            key = PipelineWithMetrics.getProcessorKey(searchProcessor);
            statsBuilder.addResponseProcessorStats(this.getId(), key, searchProcessor.getType(), this.responseProcessorMetrics.get(key));
        }
    }
}

