/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.profile;

import io.skylite.OpenSearchVersion;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public class NetworkTime
implements Writeable {
    private long inboundNetworkTime;
    private long outboundNetworkTime;

    public NetworkTime(long inboundTime, long outboundTime) {
        this.inboundNetworkTime = inboundTime;
        this.outboundNetworkTime = outboundTime;
    }

    public NetworkTime(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(OpenSearchVersion.V_2_0_0)) {
            this.inboundNetworkTime = in.readVLong();
            this.outboundNetworkTime = in.readVLong();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_0_0)) {
            out.writeVLong(this.inboundNetworkTime);
            out.writeVLong(this.outboundNetworkTime);
        }
    }

    public long getInboundNetworkTime() {
        return this.inboundNetworkTime;
    }

    public long getOutboundNetworkTime() {
        return this.outboundNetworkTime;
    }

    public void setInboundNetworkTime(long newTime) {
        this.inboundNetworkTime = newTime;
    }

    public void setOutboundNetworkTime(long newTime) {
        this.outboundNetworkTime = newTime;
    }
}

