/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.profile;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.search.profile.NetworkTime;
import io.skylite.core.search.profile.aggregation.AggregationProfileShardResult;
import io.skylite.core.search.profile.query.QueryProfileShardResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProfileShardResult
implements Writeable {
    private final List<QueryProfileShardResult> queryProfileResults;
    private final AggregationProfileShardResult aggProfileShardResult;
    private NetworkTime networkTime;

    public ProfileShardResult(List<QueryProfileShardResult> queryProfileResults, AggregationProfileShardResult aggProfileShardResult, NetworkTime networkTime) {
        this.aggProfileShardResult = aggProfileShardResult;
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.networkTime = networkTime;
    }

    public ProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>(profileSize);
        for (int i = 0; i < profileSize; ++i) {
            QueryProfileShardResult result = new QueryProfileShardResult(in);
            queryProfileResults.add(result);
        }
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.aggProfileShardResult = new AggregationProfileShardResult(in);
        this.networkTime = new NetworkTime(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (QueryProfileShardResult queryShardResult : this.queryProfileResults) {
            queryShardResult.writeTo(out);
        }
        this.aggProfileShardResult.writeTo(out);
        this.networkTime.writeTo(out);
    }

    public List<QueryProfileShardResult> getQueryProfileResults() {
        return this.queryProfileResults;
    }

    public AggregationProfileShardResult getAggregationProfileResults() {
        return this.aggProfileShardResult;
    }

    public NetworkTime getNetworkTime() {
        return this.networkTime;
    }

    public void setNetworkTime(NetworkTime newTime) {
        this.networkTime.setInboundNetworkTime(newTime.getInboundNetworkTime());
        this.networkTime.setOutboundNetworkTime(newTime.getOutboundNetworkTime());
    }
}

