/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.profile;

import io.skylite.core.search.internal.ProfilableIndexSearcher;
import io.skylite.core.search.profile.aggregation.AggregationProfiler;
import io.skylite.core.search.profile.aggregation.ConcurrentAggregationProfiler;
import io.skylite.core.search.profile.query.ConcurrentQueryProfileTree;
import io.skylite.core.search.profile.query.ConcurrentQueryProfiler;
import io.skylite.core.search.profile.query.InternalQueryProfileTree;
import io.skylite.core.search.profile.query.QueryProfiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Profilers {
    private final ProfilableIndexSearcher searcher;
    private final List<QueryProfiler> queryProfilers;
    private final AggregationProfiler aggProfiler;
    private final boolean isConcurrentSegmentSearchEnabled;

    public Profilers(ProfilableIndexSearcher searcher, boolean isConcurrentSegmentSearchEnabled) {
        this.searcher = searcher;
        this.isConcurrentSegmentSearchEnabled = isConcurrentSegmentSearchEnabled;
        this.queryProfilers = new ArrayList<QueryProfiler>();
        this.aggProfiler = isConcurrentSegmentSearchEnabled ? new ConcurrentAggregationProfiler() : new AggregationProfiler();
        this.addQueryProfiler();
    }

    public QueryProfiler addQueryProfiler() {
        QueryProfiler profiler = this.isConcurrentSegmentSearchEnabled ? new ConcurrentQueryProfiler(new ConcurrentQueryProfileTree()) : new QueryProfiler(new InternalQueryProfileTree());
        this.searcher.setProfiler(profiler);
        this.queryProfilers.add(profiler);
        return profiler;
    }

    public QueryProfiler getCurrentQueryProfiler() {
        return this.queryProfilers.get(this.queryProfilers.size() - 1);
    }

    public List<QueryProfiler> getQueryProfilers() {
        return Collections.unmodifiableList(this.queryProfilers);
    }

    public AggregationProfiler getAggregationProfiler() {
        return this.aggProfiler;
    }
}

