/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.SkyliteException;
import io.skylite.core.aggregations.AggregationProcessor;
import io.skylite.core.aggregations.ConcurrentAggregationProcessor;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.profile.query.ProfileCollectorManager;
import io.skylite.core.search.query.QueryCollectorContext;
import io.skylite.core.search.query.QueryCollectorManagerContext;
import io.skylite.core.search.query.QueryPhase;
import io.skylite.core.search.query.QueryPhaseExecutionException;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.query.ReduceableSearchResult;
import io.skylite.core.search.query.TopDocsCollectorContext;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Query;

public class ConcurrentQueryPhaseSearcher
extends QueryPhase.DefaultQueryPhaseSearcher {
    private static final Logger LOGGER = LogManager.getLogger(ConcurrentQueryPhaseSearcher.class);
    private final AggregationProcessor aggregationProcessor = new ConcurrentAggregationProcessor();

    @Override
    protected boolean searchWithCollector(SearchExecutionContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
        return ConcurrentQueryPhaseSearcher.searchWithCollectorManager(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
    }

    private static boolean searchWithCollectorManager(SearchExecutionContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectorContexts, boolean hasFilterCollector, boolean timeoutSet) throws IOException {
        CollectorManager<? extends Collector, ReduceableSearchResult> collectorManager;
        TopDocsCollectorContext topDocsFactory = TopDocsCollectorContext.createTopDocsCollectorContext(searchContext, hasFilterCollector);
        collectorContexts.addFirst(topDocsFactory);
        QuerySearchResult queryResult = searchContext.queryResult();
        if (searchContext.getProfilers() != null) {
            ProfileCollectorManager<? extends Collector, ReduceableSearchResult> profileCollectorManager = QueryCollectorManagerContext.createQueryCollectorManagerWithProfiler(collectorContexts);
            searchContext.getProfilers().getCurrentQueryProfiler().setCollector(profileCollectorManager);
            collectorManager = profileCollectorManager;
        } else {
            collectorManager = QueryCollectorManagerContext.createQueryCollectorManager(collectorContexts);
        }
        try {
            ReduceableSearchResult result = (ReduceableSearchResult)searcher.search(query, collectorManager);
            result.reduce(queryResult);
        }
        catch (RuntimeException re) {
            ConcurrentQueryPhaseSearcher.rethrowCauseIfPossible(re, searchContext);
        }
        if (searchContext.isSearchTimedOut()) {
            assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
            if (!searchContext.request().allowPartialSearchResults()) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
            }
            queryResult.searchTimedOut(true);
        }
        if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
            queryResult.terminatedEarly(false);
        }
        return topDocsFactory.shouldRescore();
    }

    @Override
    public AggregationProcessor aggregationProcessor(SearchExecutionContext searchContext) {
        return this.aggregationProcessor;
    }

    private static <T extends Exception> void rethrowCauseIfPossible(RuntimeException re, SearchExecutionContext searchContext) throws T {
        Throwable t;
        if (re.getCause() == null || re instanceof SkyliteException) {
            throw re;
        }
        if ((re.getCause() instanceof ExecutionException || re.getCause() instanceof InterruptedException) && (t = re.getCause()).getCause() != null) {
            throw (Exception)t.getCause();
        }
        throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute concurrent segment search thread", re.getCause());
    }
}

