/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.core.search.query.EarlyTerminatingCollector;
import io.skylite.core.search.query.EarlyTerminatingListener;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;

public class EarlyTerminatingCollectorManager<C extends Collector>
implements CollectorManager<EarlyTerminatingCollector, ReduceableSearchResult>,
EarlyTerminatingListener {
    private final CollectorManager<C, ReduceableSearchResult> manager;
    private final int maxCountHits;
    private boolean forceTermination;

    EarlyTerminatingCollectorManager(CollectorManager<C, ReduceableSearchResult> manager, int maxCountHits, boolean forceTermination) {
        this.manager = manager;
        this.maxCountHits = maxCountHits;
        this.forceTermination = forceTermination;
    }

    public EarlyTerminatingCollector newCollector() throws IOException {
        return new EarlyTerminatingCollector(this.manager.newCollector(), this.maxCountHits, false);
    }

    public ReduceableSearchResult reduce(Collection<EarlyTerminatingCollector> collectors) throws IOException {
        ArrayList<Collector> innerCollectors = new ArrayList<Collector>(collectors.size());
        boolean didTerminateEarly = false;
        for (EarlyTerminatingCollector collector : collectors) {
            innerCollectors.add(collector.getCollector());
            if (!collector.hasEarlyTerminated()) continue;
            didTerminateEarly = true;
        }
        if (didTerminateEarly) {
            this.onEarlyTermination(this.maxCountHits, this.forceTermination);
            final ReduceableSearchResult result = (ReduceableSearchResult)this.manager.reduce(innerCollectors);
            return new ReduceableSearchResult(){

                @Override
                public void reduce(QuerySearchResult r) throws IOException {
                    result.reduce(r);
                    r.terminatedEarly(true);
                }
            };
        }
        return (ReduceableSearchResult)this.manager.reduce(innerCollectors);
    }

    @Override
    public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
        if (this.manager instanceof EarlyTerminatingListener) {
            ((EarlyTerminatingListener)this.manager).onEarlyTermination(maxCountHits, forcedTermination);
        }
    }
}

