/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.core.lucene.MinimumScoreCollector;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;

class MinimumCollectorManager
implements CollectorManager<MinimumScoreCollector, ReduceableSearchResult> {
    private final CollectorManager<? extends Collector, ReduceableSearchResult> manager;
    private final float minimumScore;

    MinimumCollectorManager(CollectorManager<? extends Collector, ReduceableSearchResult> manager, float minimumScore) {
        this.manager = manager;
        this.minimumScore = minimumScore;
    }

    public MinimumScoreCollector newCollector() throws IOException {
        return new MinimumScoreCollector(this.manager.newCollector(), this.minimumScore);
    }

    public ReduceableSearchResult reduce(Collection<MinimumScoreCollector> collectors) throws IOException {
        ArrayList<Collector> subCollectors = new ArrayList<Collector>();
        for (MinimumScoreCollector collector : collectors) {
            subCollectors.add(collector.getCollector());
        }
        return (ReduceableSearchResult)this.manager.reduce(subCollectors);
    }
}

