/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.ScoreMode;

public class MultiCollectorWrapper
implements Collector {
    private final MultiCollector delegate;
    private final Collection<Collector> collectors;

    MultiCollectorWrapper(MultiCollector delegate, Collection<Collector> collectors) {
        this.delegate = delegate;
        this.collectors = collectors;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.delegate.getLeafCollector(context);
    }

    public ScoreMode scoreMode() {
        return this.delegate.scoreMode();
    }

    public Collection<Collector> getCollectors() {
        return this.collectors;
    }

    public static Collector wrap(Collector ... collectors) {
        List<Collector> collectorsList = Arrays.asList(collectors);
        Collector collector = MultiCollector.wrap(collectorsList);
        if (collector instanceof MultiCollector) {
            return new MultiCollectorWrapper((MultiCollector)collector, collectorsList);
        }
        return collector;
    }
}

