/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.common.CachedSupplier;
import io.skylite.common.Nullable;
import io.skylite.core.action.search.MaxScoreCollector;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.query.LuceniaToParentBlockJoinQuery;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.lucene.search.TopDocsAndMaxScore;
import io.skylite.core.lucene.search.function.FunctionScoreQuery;
import io.skylite.core.lucene.search.grouping.SinglePassGroupingCollector;
import io.skylite.core.lucene.search.grouping.TopFieldGroups;
import io.skylite.core.search.collapse.CollapseContext;
import io.skylite.core.search.internal.ScrollContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.query.EarlyTerminatingCollector;
import io.skylite.core.search.query.EarlyTerminatingCollectorManager;
import io.skylite.core.search.query.EarlyTerminatingListener;
import io.skylite.core.search.query.MultiCollectorWrapper;
import io.skylite.core.search.query.QueryCollectorContext;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.query.ReduceableSearchResult;
import io.skylite.core.search.query.TotalHitCountCollectorManager;
import io.skylite.core.search.rescore.RescoreContext;
import io.skylite.core.search.sort.SortAndFormats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.join.ScoreMode;

public abstract class TopDocsCollectorContext
extends QueryCollectorContext {
    protected final int numHits;

    TopDocsCollectorContext(String profilerName, int numHits) {
        super(profilerName);
        this.numHits = numHits;
    }

    final int numHits() {
        return this.numHits;
    }

    public boolean shouldRescore() {
        return false;
    }

    static int shortcutTotalHitCount(IndexReader reader, Query query) throws IOException {
        while (query instanceof ConstantScoreQuery || query instanceof BoostQuery) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (!(query instanceof BoostQuery)) continue;
            query = ((BoostQuery)query).getQuery();
        }
        if (query.getClass() == MatchAllDocsQuery.class) {
            return reader.numDocs();
        }
        boolean hasDeletions = reader.hasDeletions();
        List leaves = reader.leaves();
        if (query.getClass() == TermQuery.class && !hasDeletions) {
            Term term = ((TermQuery)query).getTerm();
            int count = 0;
            for (LeafReaderContext context : leaves) {
                count += context.reader().docFreq(term);
            }
            return count;
        }
        if (query.getClass() == FieldExistsQuery.class && !hasDeletions) {
            String field = ((FieldExistsQuery)query).getField();
            int count = 0;
            for (LeafReaderContext context : leaves) {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                if (fieldInfo.getPointIndexDimensionCount() > 0) {
                    PointValues points = context.reader().getPointValues(field);
                    if (points == null) continue;
                    count += points.getDocCount();
                    continue;
                }
                IndexOptions indexOptions = fieldInfo.getIndexOptions();
                if (indexOptions != IndexOptions.NONE) {
                    Terms terms = context.reader().terms(field);
                    if (terms == null) continue;
                    count += terms.getDocCount();
                    continue;
                }
                return -1;
            }
            return count;
        }
        return -1;
    }

    public static TopDocsCollectorContext createTopDocsCollectorContext(SearchExecutionContext searchContext, boolean hasFilterCollector) throws IOException {
        boolean rescore;
        IndexReader reader = searchContext.searcher().getIndexReader();
        Query query = searchContext.query();
        int totalNumDocs = Math.max(1, reader.numDocs());
        if (searchContext.size() == 0) {
            return new EmptyTopDocsCollectorContext(reader, query, searchContext.sort(), searchContext.trackTotalHitsUpTo(), hasFilterCollector);
        }
        if (searchContext.scrollContext() != null) {
            return new ScrollingTopDocsCollectorContext(reader, query, searchContext.scrollContext(), searchContext.sort(), Math.min(searchContext.size(), totalNumDocs), searchContext.trackScores(), searchContext.numberOfShards(), searchContext.scrollContext().totalHits != null ? -1 : Integer.MAX_VALUE, hasFilterCollector);
        }
        if (searchContext.collapse() != null) {
            return new CollapsingTopDocsCollectorContext(searchContext.collapse(), searchContext.sort(), Math.min(searchContext.from() + searchContext.size(), totalNumDocs), searchContext.sort() == null || searchContext.trackScores());
        }
        int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
        boolean bl = rescore = !searchContext.rescore().isEmpty();
        if (rescore) {
            assert (searchContext.sort() == null);
            for (RescoreContext rescoreContext : searchContext.rescore()) {
                numDocs = Math.max(numDocs, rescoreContext.getWindowSize());
            }
        }
        return new SimpleTopDocsCollectorContext(reader, query, searchContext.sort(), (ScoreDoc)searchContext.searchAfter(), numDocs, searchContext.trackScores(), searchContext.trackTotalHitsUpTo(), hasFilterCollector){

            @Override
            public boolean shouldRescore() {
                return rescore;
            }
        };
    }

    static boolean hasInfMaxScore(Query query) {
        MaxScoreQueryVisitor visitor = new MaxScoreQueryVisitor();
        query.visit((QueryVisitor)visitor);
        return visitor.hasInfMaxScore;
    }

    static class EmptyTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final Sort sort;
        private final Collector collector;
        private final Supplier<TotalHits> hitCountSupplier;
        private final int trackTotalHitsUpTo;
        private final int hitCount;

        private EmptyTopDocsCollectorContext(IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super("search_count", 0);
            this.sort = sortAndFormats == null ? null : sortAndFormats.sort;
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            if (this.trackTotalHitsUpTo == -1) {
                this.collector = new EarlyTerminatingCollector((Collector)new TotalHitCountCollector(), 0, false);
                this.hitCountSupplier = () -> new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                this.hitCount = Integer.MIN_VALUE;
            } else {
                TotalHitCountCollector hitCountCollector = new TotalHitCountCollector();
                int n = this.hitCount = hasFilterCollector ? -1 : EmptyTopDocsCollectorContext.shortcutTotalHitCount(reader, query);
                if (this.hitCount == -1) {
                    if (this.trackTotalHitsUpTo == Integer.MAX_VALUE) {
                        this.collector = hitCountCollector;
                        this.hitCountSupplier = () -> new TotalHits((long)hitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO);
                    } else {
                        EarlyTerminatingCollector col = new EarlyTerminatingCollector((Collector)hitCountCollector, trackTotalHitsUpTo, false);
                        this.collector = col;
                        this.hitCountSupplier = () -> new TotalHits((long)hitCountCollector.getTotalHits(), col.hasEarlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO);
                    }
                } else {
                    this.collector = new EarlyTerminatingCollector((Collector)hitCountCollector, 0, false);
                    this.hitCountSupplier = () -> new TotalHits((long)this.hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
        }

        @Override
        CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
            assert (in == null);
            Object manager = null;
            manager = this.trackTotalHitsUpTo == -1 ? new EarlyTerminatingCollectorManager<TotalHitCountCollector>(new TotalHitCountCollectorManager.Empty(new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO), this.sort), 0, false) : (this.hitCount == -1 ? (this.trackTotalHitsUpTo == Integer.MAX_VALUE ? new TotalHitCountCollectorManager(this.sort) : new EarlyTerminatingCollectorManager<TotalHitCountCollector>(new TotalHitCountCollectorManager(this.sort), this.trackTotalHitsUpTo, false)) : new EarlyTerminatingCollectorManager<TotalHitCountCollector>(new TotalHitCountCollectorManager.Empty(new TotalHits((long)this.hitCount, TotalHits.Relation.EQUAL_TO), this.sort), 0, false));
            return manager;
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        @Override
        void postProcess(QuerySearchResult result) {
            TotalHits totalHitCount = this.hitCountSupplier.get();
            Object topDocs = this.sort != null ? new TopFieldDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS);
            result.topDocs(new TopDocsAndMaxScore((TopDocs)topDocs, Float.NaN), null);
        }
    }

    static class ScrollingTopDocsCollectorContext
    extends SimpleTopDocsCollectorContext {
        private final ScrollContext scrollContext;
        private final int numberOfShards;

        private ScrollingTopDocsCollectorContext(IndexReader reader, Query query, ScrollContext scrollContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore, int numberOfShards, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super(reader, query, sortAndFormats, scrollContext.lastEmittedDoc, numHits, trackMaxScore, trackTotalHitsUpTo, hasFilterCollector);
            this.scrollContext = Objects.requireNonNull(scrollContext);
            this.numberOfShards = numberOfShards;
        }

        @Override
        protected ReduceableSearchResult reduceWith(TopDocs topDocs, float maxScore, Integer terminatedAfter) {
            return result -> {
                TopDocsAndMaxScore topDocsAndMaxScore = this.newTopDocs(topDocs, maxScore, terminatedAfter);
                if (this.scrollContext.totalHits == null) {
                    this.scrollContext.totalHits = topDocsAndMaxScore.topDocs.totalHits;
                    this.scrollContext.maxScore = topDocsAndMaxScore.maxScore;
                } else {
                    topDocsAndMaxScore.topDocs.totalHits = this.scrollContext.totalHits;
                    topDocsAndMaxScore.maxScore = this.scrollContext.maxScore;
                }
                if (this.numberOfShards == 1 && topDocsAndMaxScore.topDocs.scoreDocs.length > 0) {
                    this.scrollContext.lastEmittedDoc = topDocsAndMaxScore.topDocs.scoreDocs[topDocsAndMaxScore.topDocs.scoreDocs.length - 1];
                }
                result.topDocs(topDocsAndMaxScore, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
            };
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopDocsAndMaxScore topDocs = this.newTopDocs();
            if (this.scrollContext.totalHits == null) {
                this.scrollContext.totalHits = topDocs.topDocs.totalHits;
                this.scrollContext.maxScore = topDocs.maxScore;
            } else {
                topDocs.topDocs.totalHits = this.scrollContext.totalHits;
                topDocs.maxScore = this.scrollContext.maxScore;
            }
            if (this.numberOfShards == 1 && topDocs.topDocs.scoreDocs.length > 0) {
                this.scrollContext.lastEmittedDoc = topDocs.topDocs.scoreDocs[topDocs.topDocs.scoreDocs.length - 1];
            }
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }
    }

    static class CollapsingTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final DocValueFormat[] sortFmt;
        private final SinglePassGroupingCollector<?> topDocsCollector;
        private final Collector collector;
        private final Supplier<Float> maxScoreSupplier;
        private final CollapseContext collapseContext;
        private final boolean trackMaxScore;
        private final Sort sort;

        private CollapsingTopDocsCollectorContext(CollapseContext collapseContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore) {
            super("search_top_hits", numHits);
            DocValueFormat[] docValueFormatArray;
            assert (numHits > 0);
            assert (collapseContext != null);
            Sort sort = this.sort = sortAndFormats == null ? Sort.RELEVANCE : sortAndFormats.sort;
            if (sortAndFormats == null) {
                DocValueFormat[] docValueFormatArray2 = new DocValueFormat[1];
                docValueFormatArray = docValueFormatArray2;
                docValueFormatArray2[0] = DocValueFormat.RAW;
            } else {
                docValueFormatArray = sortAndFormats.formats;
            }
            this.sortFmt = docValueFormatArray;
            this.collapseContext = collapseContext;
            this.topDocsCollector = collapseContext.createTopDocs(this.sort, numHits);
            this.trackMaxScore = trackMaxScore;
            MaxScoreCollector maxScoreCollector = null;
            if (trackMaxScore) {
                maxScoreCollector = new MaxScoreCollector();
                this.maxScoreSupplier = maxScoreCollector::getMaxScore;
            } else {
                maxScoreCollector = null;
                this.maxScoreSupplier = () -> Float.valueOf(Float.NaN);
            }
            this.collector = MultiCollector.wrap((Collector[])new Collector[]{this.topDocsCollector, maxScoreCollector});
        }

        @Override
        Collector create(Collector in) throws IOException {
            assert (in == null);
            return this.collector;
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopFieldGroups topDocs = this.topDocsCollector.getTopGroups(0);
            result.topDocs(new TopDocsAndMaxScore((TopDocs)topDocs, this.maxScoreSupplier.get().floatValue()), this.sortFmt);
        }

        @Override
        CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
            return new CollectorManager<Collector, ReduceableSearchResult>(){

                public Collector newCollector() throws IOException {
                    MaxScoreCollector maxScoreCollector = null;
                    if (trackMaxScore) {
                        maxScoreCollector = new MaxScoreCollector();
                    }
                    return MultiCollectorWrapper.wrap(new Collector[]{collapseContext.createTopDocs(sort, numHits), maxScoreCollector});
                }

                public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
                    ArrayList<Collector> subs = new ArrayList<Collector>();
                    for (Collector collector : collectors) {
                        if (collector instanceof MultiCollectorWrapper) {
                            subs.addAll(((MultiCollectorWrapper)collector).getCollectors());
                            continue;
                        }
                        subs.add(collector);
                    }
                    ArrayList<TopFieldGroups> topFieldDocs = new ArrayList<TopFieldGroups>();
                    float maxScore = Float.NaN;
                    for (Collector collector : subs) {
                        if (collector instanceof SinglePassGroupingCollector) {
                            topFieldDocs.add(((SinglePassGroupingCollector)collector).getTopGroups(0));
                            continue;
                        }
                        if (!(collector instanceof MaxScoreCollector)) continue;
                        float score = ((MaxScoreCollector)collector).getMaxScore();
                        if (Float.isNaN(maxScore)) {
                            maxScore = score;
                            continue;
                        }
                        maxScore = Math.max(maxScore, score);
                    }
                    return this.reduceWith(topFieldDocs, maxScore);
                }
            };
        }

        protected ReduceableSearchResult reduceWith(Collection<TopFieldGroups> topFieldDocs, float maxScore) {
            return result -> {
                TopFieldGroups topDocs = TopFieldGroups.merge(this.sort, 0, this.numHits, topFieldDocs.toArray(new TopFieldGroups[0]), true);
                result.topDocs(new TopDocsAndMaxScore((TopDocs)topDocs, maxScore), this.sortFmt);
            };
        }
    }

    private static class MaxScoreQueryVisitor
    extends QueryVisitor {
        private boolean hasInfMaxScore;

        private MaxScoreQueryVisitor() {
        }

        public void visitLeaf(Query query) {
            this.checkMaxScoreInfo(query);
        }

        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (occur != BooleanClause.Occur.MUST) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            this.checkMaxScoreInfo(parent);
            return this;
        }

        void checkMaxScoreInfo(Query query) {
            if (query instanceof DefaultInfMaxScore && ((DefaultInfMaxScore)query).defaultHasInfMaxScore() || query instanceof SpanQuery || query instanceof FunctionScoreQuery) {
                this.hasInfMaxScore = true;
            } else if (query instanceof LuceniaToParentBlockJoinQuery) {
                LuceniaToParentBlockJoinQuery q = (LuceniaToParentBlockJoinQuery)query;
                this.hasInfMaxScore |= q.getScoreMode() != ScoreMode.None;
            }
        }
    }

    public static interface DefaultInfMaxScore {
        default public boolean defaultHasInfMaxScore() {
            return true;
        }
    }

    static abstract class SimpleTopDocsCollectorContext
    extends TopDocsCollectorContext {
        @Nullable
        protected final SortAndFormats sortAndFormats;
        private final Collector collector;
        private final Supplier<TotalHits> totalHitsSupplier;
        private final Supplier<TopDocs> topDocsSupplier;
        private final Supplier<Float> maxScoreSupplier;
        private final ScoreDoc searchAfter;
        private final int trackTotalHitsUpTo;
        private final boolean trackMaxScore;
        private final boolean hasInfMaxScore;
        private final int hitCount;

        private static TopDocsCollector<?> createCollector(@Nullable SortAndFormats sortAndFormats, int numHits, @Nullable ScoreDoc searchAfter, int hitCountThreshold) {
            if (sortAndFormats == null) {
                return new TopScoreDocCollectorManager(numHits, searchAfter, hitCountThreshold).newCollector();
            }
            return new TopFieldCollectorManager(sortAndFormats.sort, numHits, (FieldDoc)searchAfter, hitCountThreshold).newCollector();
        }

        private static CollectorManager<? extends TopDocsCollector<?>, ? extends TopDocs> createCollectorManager(@Nullable SortAndFormats sortAndFormats, int numHits, @Nullable ScoreDoc searchAfter, int hitCountThreshold) {
            if (sortAndFormats == null) {
                if (searchAfter != null) {
                    return new TopScoreDocCollectorManager(numHits, (ScoreDoc)new FieldDoc(searchAfter.doc, searchAfter.score), hitCountThreshold);
                }
                return new TopScoreDocCollectorManager(numHits, null, hitCountThreshold);
            }
            return new TopFieldCollectorManager(sortAndFormats.sort, numHits, (FieldDoc)searchAfter, hitCountThreshold);
        }

        private SimpleTopDocsCollectorContext(IndexReader reader, Query query, @Nullable SortAndFormats sortAndFormats, @Nullable ScoreDoc searchAfter, int numHits, boolean trackMaxScore, int trackTotalHitsUpTo, boolean hasFilterCollector) throws IOException {
            super("search_top_hits", numHits);
            TopDocsCollector<?> topDocsCollector;
            this.sortAndFormats = sortAndFormats;
            this.searchAfter = searchAfter;
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            this.trackMaxScore = trackMaxScore;
            this.hasInfMaxScore = SimpleTopDocsCollectorContext.hasInfMaxScore(query);
            if ((sortAndFormats == null || SortField.FIELD_SCORE.equals((Object)sortAndFormats.sort.getSort()[0])) && this.hasInfMaxScore) {
                topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, Integer.MAX_VALUE);
                this.topDocsSupplier = new CachedSupplier(() -> topDocsCollector.topDocs());
                this.totalHitsSupplier = () -> this.topDocsSupplier.get().totalHits;
                this.hitCount = Integer.MIN_VALUE;
            } else if (trackTotalHitsUpTo == -1) {
                topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, 1);
                this.topDocsSupplier = new CachedSupplier(() -> topDocsCollector.topDocs());
                this.totalHitsSupplier = () -> new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                this.hitCount = -1;
            } else {
                int n = this.hitCount = hasFilterCollector ? -1 : SimpleTopDocsCollectorContext.shortcutTotalHitCount(reader, query);
                if (this.hitCount == -1) {
                    topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, trackTotalHitsUpTo);
                    this.topDocsSupplier = new CachedSupplier(() -> topDocsCollector.topDocs());
                    this.totalHitsSupplier = () -> this.topDocsSupplier.get().totalHits;
                } else {
                    topDocsCollector = SimpleTopDocsCollectorContext.createCollector(sortAndFormats, numHits, searchAfter, 1);
                    this.topDocsSupplier = new CachedSupplier(() -> topDocsCollector.topDocs());
                    this.totalHitsSupplier = () -> new TotalHits((long)this.hitCount, TotalHits.Relation.EQUAL_TO);
                }
            }
            MaxScoreCollector maxScoreCollector = null;
            if (sortAndFormats == null) {
                this.maxScoreSupplier = () -> {
                    TopDocs topDocs = this.topDocsSupplier.get();
                    if (topDocs.scoreDocs.length == 0) {
                        return Float.valueOf(Float.NaN);
                    }
                    return Float.valueOf(topDocs.scoreDocs[0].score);
                };
            } else if (trackMaxScore) {
                maxScoreCollector = new MaxScoreCollector();
                this.maxScoreSupplier = maxScoreCollector::getMaxScore;
            } else {
                this.maxScoreSupplier = () -> Float.valueOf(Float.NaN);
            }
            this.collector = MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, maxScoreCollector});
        }

        @Override
        CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
            assert (in == null);
            return new SimpleTopDocsCollectorManager();
        }

        protected ReduceableSearchResult reduceWith(TopDocs topDocs, float maxScore, Integer terminatedAfter) {
            return result -> {
                TopDocsAndMaxScore topDocsAndMaxScore = this.newTopDocs(topDocs, maxScore, terminatedAfter);
                result.topDocs(topDocsAndMaxScore, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
            };
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        TopDocsAndMaxScore newTopDocs(TopDocs topDocs, float maxScore, Integer terminatedAfter) {
            TopDocs newTopDocs;
            TotalHits totalHits = null;
            totalHits = (this.sortAndFormats == null || SortField.FIELD_SCORE.equals((Object)this.sortAndFormats.sort.getSort()[0])) && this.hasInfMaxScore ? topDocs.totalHits : (this.trackTotalHitsUpTo == -1 ? new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) : (this.hitCount == -1 ? topDocs.totalHits : new TotalHits((long)this.hitCount, TotalHits.Relation.EQUAL_TO)));
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (terminatedAfter != null) {
                if (totalHits.value() > (long)terminatedAfter.intValue()) {
                    totalHits = new TotalHits((long)terminatedAfter.intValue(), TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
                }
                if (scoreDocs != null && scoreDocs.length > terminatedAfter) {
                    scoreDocs = Arrays.copyOf(scoreDocs, (int)terminatedAfter);
                }
            }
            if (topDocs instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)topDocs;
                newTopDocs = new TopFieldDocs(totalHits, scoreDocs, fieldDocs.fields);
            } else {
                newTopDocs = new TopDocs(totalHits, scoreDocs);
            }
            if (Float.isNaN(maxScore) && newTopDocs.scoreDocs.length > 0 && this.sortAndFormats == null) {
                return new TopDocsAndMaxScore(newTopDocs, newTopDocs.scoreDocs[0].score);
            }
            return new TopDocsAndMaxScore(newTopDocs, maxScore);
        }

        TopDocsAndMaxScore newTopDocs() {
            TopDocs newTopDocs;
            TopDocs in = this.topDocsSupplier.get();
            float maxScore = this.maxScoreSupplier.get().floatValue();
            if (in instanceof TopFieldDocs) {
                TopFieldDocs fieldDocs = (TopFieldDocs)in;
                newTopDocs = new TopFieldDocs(this.totalHitsSupplier.get(), fieldDocs.scoreDocs, fieldDocs.fields);
            } else {
                newTopDocs = new TopDocs(this.totalHitsSupplier.get(), in.scoreDocs);
            }
            return new TopDocsAndMaxScore(newTopDocs, maxScore);
        }

        @Override
        void postProcess(QuerySearchResult result) throws IOException {
            TopDocsAndMaxScore topDocs = this.newTopDocs();
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }

        private class SimpleTopDocsCollectorManager
        implements CollectorManager<Collector, ReduceableSearchResult>,
        EarlyTerminatingListener {
            private Integer terminatedAfter;
            private final CollectorManager<? extends TopDocsCollector<?>, ? extends TopDocs> manager;

            private SimpleTopDocsCollectorManager() {
                this.manager = (SimpleTopDocsCollectorContext.this.sortAndFormats == null || SortField.FIELD_SCORE.equals((Object)SimpleTopDocsCollectorContext.this.sortAndFormats.sort.getSort()[0])) && SimpleTopDocsCollectorContext.this.hasInfMaxScore ? SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, Integer.MAX_VALUE) : (SimpleTopDocsCollectorContext.this.trackTotalHitsUpTo == -1 ? SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, 1) : (SimpleTopDocsCollectorContext.this.hitCount == -1 ? SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, SimpleTopDocsCollectorContext.this.trackTotalHitsUpTo) : SimpleTopDocsCollectorContext.createCollectorManager(SimpleTopDocsCollectorContext.this.sortAndFormats, SimpleTopDocsCollectorContext.this.numHits, SimpleTopDocsCollectorContext.this.searchAfter, 1)));
            }

            @Override
            public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
                this.terminatedAfter = maxCountHits;
            }

            public Collector newCollector() throws IOException {
                MaxScoreCollector maxScoreCollector = null;
                if (SimpleTopDocsCollectorContext.this.sortAndFormats != null && SimpleTopDocsCollectorContext.this.trackMaxScore) {
                    maxScoreCollector = new MaxScoreCollector();
                }
                return MultiCollectorWrapper.wrap(new Collector[]{this.manager.newCollector(), maxScoreCollector});
            }

            public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
                ArrayList<TopDocsCollector> topDocsCollectors = new ArrayList<TopDocsCollector>();
                ArrayList<MaxScoreCollector> maxScoreCollectors = new ArrayList<MaxScoreCollector>();
                for (Collector collector : collectors) {
                    if (collector instanceof MultiCollectorWrapper) {
                        for (Collector sub : ((MultiCollectorWrapper)collector).getCollectors()) {
                            if (sub instanceof TopDocsCollector) {
                                topDocsCollectors.add((TopDocsCollector)sub);
                                continue;
                            }
                            if (!(sub instanceof MaxScoreCollector)) continue;
                            maxScoreCollectors.add((MaxScoreCollector)sub);
                        }
                        continue;
                    }
                    if (collector instanceof TopDocsCollector) {
                        topDocsCollectors.add((TopDocsCollector)collector);
                        continue;
                    }
                    if (!(collector instanceof MaxScoreCollector)) continue;
                    maxScoreCollectors.add((MaxScoreCollector)collector);
                }
                float maxScore = Float.NaN;
                for (MaxScoreCollector collector : maxScoreCollectors) {
                    float score = collector.getMaxScore();
                    if (Float.isNaN(maxScore)) {
                        maxScore = score;
                        continue;
                    }
                    maxScore = Math.max(maxScore, score);
                }
                TopDocs topDocs = (TopDocs)this.manager.reduce(topDocsCollectors);
                return SimpleTopDocsCollectorContext.this.reduceWith(topDocs, maxScore, this.terminatedAfter);
            }
        }
    }
}

