/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.query;

import io.skylite.core.lucene.Lucene;
import io.skylite.core.lucene.search.TopDocsAndMaxScore;
import io.skylite.core.search.query.EarlyTerminatingListener;
import io.skylite.core.search.query.ReduceableSearchResult;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;

public class TotalHitCountCollectorManager
implements CollectorManager<TotalHitCountCollector, ReduceableSearchResult>,
EarlyTerminatingListener {
    private static final TotalHitCountCollector EMPTY_COLLECTOR = new TotalHitCountCollector(){

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return new LeafCollector(this){

                public void setScorer(Scorable scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                }
            };
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    };
    private final Sort sort;
    private Integer terminatedAfter;

    public TotalHitCountCollectorManager(Sort sort) {
        this.sort = sort;
    }

    @Override
    public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
        this.terminatedAfter = maxCountHits;
    }

    public TotalHitCountCollector newCollector() throws IOException {
        return new TotalHitCountCollector();
    }

    public ReduceableSearchResult reduce(Collection<TotalHitCountCollector> collectors) throws IOException {
        return result -> {
            TotalHits.Relation relation = this.terminatedAfter != null ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
            int totalHits = collectors.stream().mapToInt(TotalHitCountCollector::getTotalHits).sum();
            if (this.terminatedAfter != null && totalHits > this.terminatedAfter) {
                totalHits = this.terminatedAfter;
            }
            TotalHits totalHitCount = new TotalHits((long)totalHits, relation);
            TopFieldDocs topDocs = this.sort != null ? new TopFieldDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(totalHitCount, Lucene.EMPTY_SCORE_DOCS);
            result.topDocs(new TopDocsAndMaxScore((TopDocs)topDocs, Float.NaN), null);
        };
    }

    static class Empty
    implements CollectorManager<TotalHitCountCollector, ReduceableSearchResult> {
        private final TotalHits totalHits;
        private final Sort sort;

        Empty(TotalHits totalHits, Sort sort) {
            this.totalHits = totalHits;
            this.sort = sort;
        }

        public TotalHitCountCollector newCollector() throws IOException {
            return EMPTY_COLLECTOR;
        }

        public ReduceableSearchResult reduce(Collection<TotalHitCountCollector> collectors) throws IOException {
            return result -> {
                Object topDocs = this.sort != null ? new TopFieldDocs(this.totalHits, Lucene.EMPTY_SCORE_DOCS, this.sort.getSort()) : new TopDocs(this.totalHits, Lucene.EMPTY_SCORE_DOCS);
                result.topDocs(new TopDocsAndMaxScore((TopDocs)topDocs, Float.NaN), null);
            };
        }
    }
}

