/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.slice;

import io.skylite.common.util.BitMixer;
import io.skylite.core.search.slice.SliceQuery;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public final class DocValuesSliceQuery
extends SliceQuery {
    public DocValuesSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)DocValuesSliceQuery.this.getField());
                DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    public boolean matches() throws IOException {
                        if (values.advanceExact(this.approximation.docID())) {
                            for (int i = 0; i < values.docValueCount(); ++i) {
                                if (!DocValuesSliceQuery.this.contains(BitMixer.mix((long)values.nextValue()))) continue;
                                return true;
                            }
                            return false;
                        }
                        return DocValuesSliceQuery.this.contains(0L);
                    }

                    public float matchCost() {
                        return 10.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                return new Weight.DefaultScorerSupplier((Scorer)scorer);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{DocValuesSliceQuery.this.getField()});
            }
        };
    }
}

