/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.slice;

import java.util.Objects;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

public abstract class SliceQuery
extends Query {
    private final String field;
    private final int id;
    private final int max;

    public SliceQuery(String field, int id, int max) {
        this.field = field;
        this.id = id;
        this.max = max;
    }

    protected final boolean contains(long value) {
        return Math.floorMod(value, this.max) == this.id;
    }

    public String getField() {
        return this.field;
    }

    public int getId() {
        return this.id;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (!this.sameClassAs(o)) {
            return false;
        }
        SliceQuery that = (SliceQuery)((Object)o);
        return this.field.equals(that.field) && this.id == that.id && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.id, this.max);
    }

    public String toString(String f) {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[field=" + this.field + ", id=" + this.id + ", max=" + this.max + "]";
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }
}

