/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.sort;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public enum SortMode implements Writeable
{
    MIN,
    MAX,
    SUM,
    AVG,
    MEDIAN;


    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static SortMode readFromStream(StreamInput in) throws IOException {
        return in.readEnum(SortMode.class);
    }

    public static SortMode fromString(String str) {
        Objects.requireNonNull(str, "input string is null");
        switch (str.toLowerCase(Locale.ROOT)) {
            case "min": {
                return MIN;
            }
            case "max": {
                return MAX;
            }
            case "sum": {
                return SUM;
            }
            case "avg": {
                return AVG;
            }
            case "median": {
                return MEDIAN;
            }
        }
        throw new IllegalArgumentException("Unknown SortMode [" + str + "]");
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

