/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.sort;

import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class SortValue
implements NamedWriteable,
Comparable<SortValue> {
    public static SortValue from(double d) {
        return new DoubleSortValue(d);
    }

    public static SortValue from(long l) {
        return new LongSortValue(l);
    }

    public static SortValue fromUnsigned(long l) {
        return new UnsignedLongSortValue(l);
    }

    public static List<NamedWriteableRegistry.Entry> namedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(SortValue.class, "double", DoubleSortValue::new), new NamedWriteableRegistry.Entry(SortValue.class, "long", LongSortValue::new), new NamedWriteableRegistry.Entry(SortValue.class, "unsigned_long", UnsignedLongSortValue::new));
    }

    private SortValue() {
    }

    @Override
    public final int compareTo(SortValue other) {
        int typeCompare = this.getWriteableName().compareTo(other.getWriteableName());
        if (typeCompare != 0) {
            return typeCompare;
        }
        return this.compareToSameType(other);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, DocValueFormat format) throws IOException {
        if (format == DocValueFormat.RAW) {
            return this.rawToXContent(builder);
        }
        return builder.value(this.format(format));
    }

    public abstract Object getKey();

    public abstract String format(DocValueFormat var1);

    protected abstract XContentBuilder rawToXContent(XContentBuilder var1) throws IOException;

    protected abstract int compareToSameType(SortValue var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract Number numberValue();

    private static class DoubleSortValue
    extends SortValue {
        public static final String NAME = "double";
        private final double key;

        private DoubleSortValue(double key) {
            this.key = key;
        }

        private DoubleSortValue(StreamInput in) throws IOException {
            this.key = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.key);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String format(DocValueFormat format) {
            return format.format(this.key).toString();
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder.value(this.key);
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            DoubleSortValue other = (DoubleSortValue)obj;
            return Double.compare(this.key, other.key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DoubleSortValue other = (DoubleSortValue)obj;
            return this.key == other.key;
        }

        @Override
        public int hashCode() {
            return Double.hashCode(this.key);
        }

        @Override
        public String toString() {
            return Double.toString(this.key);
        }

        @Override
        public Number numberValue() {
            return this.key;
        }
    }

    private static class LongSortValue
    extends SortValue {
        public static final String NAME = "long";
        private final long key;

        LongSortValue(long key) {
            this.key = key;
        }

        LongSortValue(StreamInput in) throws IOException {
            this.key = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String format(DocValueFormat format) {
            return format.format(this.key).toString();
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder.value(this.key);
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            LongSortValue other = (LongSortValue)obj;
            return Long.compare(this.key, other.key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            LongSortValue other = (LongSortValue)obj;
            return this.key == other.key;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.key);
        }

        @Override
        public String toString() {
            return Long.toString(this.key);
        }

        @Override
        public Number numberValue() {
            return this.key;
        }
    }

    private static class UnsignedLongSortValue
    extends SortValue {
        public static final String NAME = "unsigned_long";
        private final long key;

        UnsignedLongSortValue(long key) {
            this.key = key;
        }

        UnsignedLongSortValue(StreamInput in) throws IOException {
            this.key = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String format(DocValueFormat format) {
            return format.format(this.key).toString();
        }

        @Override
        protected XContentBuilder rawToXContent(XContentBuilder builder) throws IOException {
            return builder.value(this.key);
        }

        @Override
        protected int compareToSameType(SortValue obj) {
            UnsignedLongSortValue other = (UnsignedLongSortValue)obj;
            return Long.compareUnsigned(this.key, other.key);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            UnsignedLongSortValue other = (UnsignedLongSortValue)obj;
            return this.key == other.key;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.key);
        }

        @Override
        public String toString() {
            return Long.toUnsignedString(this.key);
        }

        @Override
        public Number numberValue() {
            return this.key;
        }
    }
}

