/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.sort;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.util.NumericUtils;

public class SortedWiderNumericSortField
extends SortedNumericSortField {
    public SortedWiderNumericSortField(String field, SortField.Type type, boolean reverse) {
        super(field, type, reverse);
    }

    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        return new NumericComparator<Number>(this, this.getField(), (Number)this.getMissingValue(), this.getReverse(), pruning, 8){

            protected long missingValueAsComparableLong() {
                if (this.missingValue == null) {
                    return Long.MAX_VALUE;
                }
                return NumericUtils.doubleToSortableLong((double)this.missingValue.doubleValue());
            }

            protected long sortableBytesToLong(byte[] bytes) {
                return NumericUtils.sortableBytesToInt((byte[])bytes, (int)0);
            }

            public int compare(int slot1, int slot2) {
                throw new UnsupportedOperationException();
            }

            public Number value(int slot) {
                throw new UnsupportedOperationException();
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int compareValues(Number first, Number second) {
                if (first == null) {
                    if (second == null) {
                        return 0;
                    }
                    return -1;
                }
                if (second == null) {
                    return 1;
                }
                return Double.compare(first.doubleValue(), second.doubleValue());
            }
        };
    }

    public static boolean isTypeSupported(SortField.Type type) {
        switch (type) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }
}

