/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest;

import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.BytesRefs;
import io.skylite.core.search.suggest.SuggestionBuilder;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SuggestBuilder
implements Writeable,
ToXContentObject {
    protected static final ParseField GLOBAL_TEXT_FIELD = new ParseField("text", new String[0]);
    private String globalText;
    private final Map<String, SuggestionBuilder<?>> suggestions = new HashMap();

    public SuggestBuilder() {
    }

    public SuggestBuilder(StreamInput in) throws IOException {
        this.globalText = in.readOptionalString();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.suggestions.put(in.readString(), in.readNamedWriteable(SuggestionBuilder.class));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.globalText);
        int size = this.suggestions.size();
        out.writeVInt(size);
        for (Map.Entry<String, SuggestionBuilder<?>> suggestion : this.suggestions.entrySet()) {
            out.writeString(suggestion.getKey());
            out.writeNamedWriteable(suggestion.getValue());
        }
    }

    public SuggestBuilder setGlobalText(@Nullable String globalText) {
        this.globalText = globalText;
        return this;
    }

    @Nullable
    public String getGlobalText() {
        return this.globalText;
    }

    public SuggestBuilder addSuggestion(String name, SuggestionBuilder<?> suggestion) {
        Objects.requireNonNull(name, "every suggestion needs a name");
        if (this.suggestions.get(name) != null) {
            throw new IllegalArgumentException("already added another suggestion with name [" + name + "]");
        }
        this.suggestions.put(name, suggestion);
        return this;
    }

    public Map<String, SuggestionBuilder<?>> getSuggestions() {
        return this.suggestions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.globalText != null) {
            builder.field("text", this.globalText);
        }
        for (Map.Entry<String, SuggestionBuilder<?>> suggestion : this.suggestions.entrySet()) {
            builder.startObject(suggestion.getKey());
            suggestion.getValue().toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static SuggestBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        String fieldName = null;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT) : "current token must be a start object";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (GLOBAL_TEXT_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    suggestBuilder.setGlobalText(parser.text());
                    continue;
                }
                throw new IllegalArgumentException("[suggest] does not support [" + fieldName + "]");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String suggestionName = fieldName;
                if (suggestionName == null) {
                    throw new IllegalArgumentException("suggestion must have name");
                }
                suggestBuilder.addSuggestion(suggestionName, SuggestionBuilder.fromXContent(parser));
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf((Object)token) + "] after [" + fieldName + "]", new Object[0]);
        }
        return suggestBuilder;
    }

    public SuggestionSearchContext build(QueryShardContext context) throws IOException {
        SuggestionSearchContext suggestionSearchContext = new SuggestionSearchContext();
        for (Map.Entry<String, SuggestionBuilder<?>> suggestion : this.suggestions.entrySet()) {
            SuggestionSearchContext.SuggestionContext suggestionContext = suggestion.getValue().build(context);
            if (suggestionContext.getText() == null) {
                if (this.globalText == null) {
                    throw new IllegalArgumentException("The required text option is missing");
                }
                suggestionContext.setText(BytesRefs.toBytesRef(this.globalText));
            }
            suggestionSearchContext.addSuggestion(suggestion.getKey(), suggestionContext);
        }
        return suggestionSearchContext;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SuggestBuilder o = (SuggestBuilder)other;
        return Objects.equals(this.globalText, o.globalText) && Objects.equals(this.suggestions, o.suggestions);
    }

    public int hashCode() {
        return Objects.hash(this.globalText, this.suggestions);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }
}

