/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest;

import io.skylite.SkyliteException;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.search.suggest.Suggester;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.util.CharsRefBuilder;

public class SuggestProcessor {
    public void process(SearchExecutionContext context) {
        SuggestionSearchContext suggest = context.suggest();
        if (suggest == null) {
            return;
        }
        try {
            CharsRefBuilder spare = new CharsRefBuilder();
            ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>(suggest.suggestions().size());
            for (Map.Entry<String, SuggestionSearchContext.SuggestionContext> entry : suggest.suggestions().entrySet()) {
                SuggestionSearchContext.SuggestionContext suggestion = entry.getValue();
                Suggester<SuggestionSearchContext.SuggestionContext> suggester = suggestion.getSuggester();
                Suggest.Suggestion<Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option>> result = suggester.execute(entry.getKey(), suggestion, context.searcher(), spare);
                if (result == null) continue;
                assert (entry.getKey().equals(result.getName()));
                suggestions.add(result);
            }
            context.queryResult().suggest(new Suggest(suggestions));
        }
        catch (IOException e) {
            throw new SkyliteException("I/O exception during suggest phase", (Throwable)e, new Object[0]);
        }
    }
}

