/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest.completion;

import io.skylite.common.Nullable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.fielddata.FieldMemoryStats;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class CompletionStats
implements Writeable,
ToXContentFragment {
    private static final String COMPLETION = "completion";
    private static final String SIZE_IN_BYTES = "size_in_bytes";
    private static final String SIZE = "size";
    private static final String FIELDS = "fields";
    private long sizeInBytes;
    @Nullable
    private FieldMemoryStats fields;

    public CompletionStats() {
    }

    public CompletionStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.fields = in.readOptionalWriteable(FieldMemoryStats::new);
    }

    public CompletionStats(long size, @Nullable FieldMemoryStats fields) {
        this.sizeInBytes = size;
        this.fields = fields;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public FieldMemoryStats getFields() {
        return this.fields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        out.writeOptionalWriteable(this.fields);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(COMPLETION);
        builder.humanReadableField(SIZE_IN_BYTES, SIZE, this.getSize());
        if (this.fields != null) {
            this.fields.toXContent(builder, FIELDS, SIZE_IN_BYTES, SIZE);
        }
        builder.endObject();
        return builder;
    }

    public void add(CompletionStats completion) {
        if (completion == null) {
            return;
        }
        this.sizeInBytes += completion.getSizeInBytes();
        if (completion.fields != null) {
            if (this.fields == null) {
                this.fields = completion.fields.copy();
            } else {
                this.fields.add(completion.fields);
            }
        }
    }
}

