/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest.completion.context;

import io.skylite.SkyliteParseException;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.MappingParser;
import io.skylite.core.search.suggest.completion.context.CategoryContextMapping;
import io.skylite.core.search.suggest.completion.context.ContextMapping;
import io.skylite.core.search.suggest.completion.context.GeoContextMapping;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.ContextQuery;
import org.apache.lucene.search.suggest.document.ContextSuggestField;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;

public class ContextMappings
implements ToXContent,
Iterable<ContextMapping<?>> {
    private final List<ContextMapping<?>> contextMappings;
    private final Map<String, ContextMapping<?>> contextNameMap;

    public ContextMappings(List<ContextMapping<?>> contextMappings) {
        if (contextMappings.size() > 255) {
            throw new UnsupportedOperationException("Maximum of 10 context types are supported was: " + contextMappings.size());
        }
        this.contextMappings = contextMappings;
        this.contextNameMap = new HashMap(contextMappings.size());
        for (ContextMapping<?> mapping : contextMappings) {
            this.contextNameMap.put(mapping.name(), mapping);
        }
    }

    public int size() {
        return this.contextMappings.size();
    }

    public ContextMapping<?> get(String name) {
        ContextMapping<?> contextMapping = this.contextNameMap.get(name);
        if (contextMapping == null) {
            ArrayList<String> keys = new ArrayList<String>(this.contextNameMap.keySet());
            Collections.sort(keys);
            throw new IllegalArgumentException("Unknown context name [" + name + "], must be one of " + ((Object)keys).toString());
        }
        return contextMapping;
    }

    public void addField(LuceneDocument document, String name, String input, int weight, Map<String, Set<String>> contexts) {
        document.add((IndexableField)new TypedContextField(name, input, weight, contexts, document));
    }

    @Override
    public Iterator<ContextMapping<?>> iterator() {
        return this.contextMappings.iterator();
    }

    public ContextQuery toContextQuery(CompletionQuery query, Map<String, List<ContextMapping.InternalQueryContext>> queryContexts) {
        ContextQuery typedContextQuery = new ContextQuery(query);
        boolean hasContext = false;
        if (!queryContexts.isEmpty()) {
            CharsRefBuilder scratch = new CharsRefBuilder();
            scratch.grow(1);
            for (int typeId = 0; typeId < this.contextMappings.size(); ++typeId) {
                scratch.setCharAt(0, (char)typeId);
                scratch.setLength(1);
                ContextMapping<?> mapping = this.contextMappings.get(typeId);
                List<ContextMapping.InternalQueryContext> internalQueryContext = queryContexts.get(mapping.name());
                if (internalQueryContext == null) continue;
                for (ContextMapping.InternalQueryContext context : internalQueryContext) {
                    scratch.append((CharSequence)context.context);
                    typedContextQuery.addContext((CharSequence)scratch.toCharsRef(), (float)context.boost, !context.isPrefix);
                    scratch.setLength(1);
                    hasContext = true;
                }
            }
        }
        if (!hasContext) {
            throw new IllegalArgumentException("Missing mandatory contexts in context query");
        }
        return typedContextQuery;
    }

    public Map<String, Set<String>> getNamedContexts(List<CharSequence> contexts) {
        HashMap<String, Set<String>> contextMap = new HashMap<String, Set<String>>(contexts.size());
        for (CharSequence typedContext : contexts) {
            char typeId = typedContext.charAt(0);
            assert (typeId < this.contextMappings.size()) : "Returned context has invalid type";
            ContextMapping<?> mapping = this.contextMappings.get(typeId);
            HashSet<String> contextEntries = (HashSet<String>)contextMap.get(mapping.name());
            if (contextEntries == null) {
                contextEntries = new HashSet<String>();
                contextMap.put(mapping.name(), contextEntries);
            }
            contextEntries.add(typedContext.subSequence(1, typedContext.length()).toString());
        }
        return contextMap;
    }

    public static ContextMappings load(Object configuration) throws SkyliteParseException {
        ArrayList<ContextMapping<?>> contextMappings;
        if (configuration instanceof List) {
            contextMappings = new ArrayList();
            List configurations = (List)configuration;
            for (Object contextConfig : configurations) {
                contextMappings.add(ContextMappings.load((Map)contextConfig));
            }
            if (contextMappings.size() == 0) {
                throw new SkyliteParseException("expected at least one context mapping", new Object[0]);
            }
        } else if (configuration instanceof Map) {
            contextMappings = Collections.singletonList(ContextMappings.load((Map)configuration));
        } else {
            throw new SkyliteParseException("expected a list or an entry of context mapping", new Object[0]);
        }
        return new ContextMappings(contextMappings);
    }

    private static ContextMapping<?> load(Map<String, Object> contextConfig) {
        String name = ContextMappings.extractRequiredValue(contextConfig, "name");
        String type = ContextMappings.extractRequiredValue(contextConfig, "type");
        ContextMapping contextMapping = switch (ContextMapping.Type.fromString(type)) {
            case ContextMapping.Type.CATEGORY -> CategoryContextMapping.load(name, contextConfig);
            case ContextMapping.Type.GEO -> GeoContextMapping.load(name, contextConfig);
            default -> throw new SkyliteParseException("unknown context type[" + type + "]", new Object[0]);
        };
        MappingParser.checkNoRemainingFields(name, contextConfig);
        return contextMapping;
    }

    private static String extractRequiredValue(Map<String, Object> contextConfig, String paramName) {
        Object paramValue = contextConfig.get(paramName);
        if (paramValue == null) {
            throw new SkyliteParseException("missing [" + paramName + "] in context mapping", new Object[0]);
        }
        contextConfig.remove(paramName);
        return paramValue.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (ContextMapping<?> contextMapping : this.contextMappings) {
            builder.startObject();
            contextMapping.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.contextMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContextMappings)) {
            return false;
        }
        ContextMappings other = (ContextMappings)obj;
        return this.contextMappings.equals(other.contextMappings);
    }

    public String toString() {
        return this.contextMappings.stream().map(ContextMapping::toString).collect(Collectors.joining(",", "[", "]"));
    }

    private class TypedContextField
    extends ContextSuggestField {
        private final Map<String, Set<String>> contexts;
        private final LuceneDocument document;

        TypedContextField(String name, String value, int weight, Map<String, Set<String>> contexts, LuceneDocument document) {
            super(name, value, weight, new CharSequence[0]);
            this.contexts = contexts;
            this.document = document;
        }

        protected Iterable<CharSequence> contexts() {
            HashSet<CharsRef> typedContexts = new HashSet<CharsRef>();
            CharsRefBuilder scratch = new CharsRefBuilder();
            scratch.grow(1);
            for (int typeId = 0; typeId < ContextMappings.this.contextMappings.size(); ++typeId) {
                scratch.setCharAt(0, (char)typeId);
                scratch.setLength(1);
                ContextMapping<?> mapping = ContextMappings.this.contextMappings.get(typeId);
                HashSet<String> contexts = new HashSet<String>(mapping.parseContext(this.document));
                if (this.contexts.get(mapping.name()) != null) {
                    contexts.addAll((Collection<String>)this.contexts.get(mapping.name()));
                }
                for (String context : contexts) {
                    scratch.append((CharSequence)context);
                    typedContexts.add(scratch.toCharsRef());
                    scratch.setLength(1);
                }
            }
            if (typedContexts.isEmpty()) {
                throw new IllegalArgumentException("Contexts are mandatory in context enabled completion field [" + this.name + "]");
            }
            return new ArrayList<CharSequence>(typedContexts);
        }
    }
}

