/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.search.suggest.phrase;

import io.skylite.core.common.text.Text;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.XLucene;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.search.suggest.Suggester;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import io.skylite.core.search.suggest.phrase.CandidateGenerator;
import io.skylite.core.search.suggest.phrase.Correction;
import io.skylite.core.search.suggest.phrase.DirectCandidateGenerator;
import io.skylite.core.search.suggest.phrase.MultiCandidateGeneratorWrapper;
import io.skylite.core.search.suggest.phrase.NoisyChannelSpellChecker;
import io.skylite.core.search.suggest.phrase.PhraseSuggestion;
import io.skylite.core.search.suggest.phrase.PhraseSuggestionContext;
import io.skylite.core.search.suggest.phrase.WordScorer;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;

public final class PhraseSuggester
extends Suggester<PhraseSuggestionContext> {
    private final BytesRef SEPARATOR = new BytesRef((CharSequence)" ");
    private static final String SUGGESTION_TEMPLATE_VAR_NAME = "suggestion";
    public static final PhraseSuggester INSTANCE = new PhraseSuggester();

    private PhraseSuggester() {
    }

    @Override
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, PhraseSuggestionContext suggestion, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        double realWordErrorLikelihood = suggestion.realworldErrorLikelihood().floatValue();
        PhraseSuggestion response = new PhraseSuggestion(name, suggestion.getSize());
        IndexReader indexReader = searcher.getIndexReader();
        List<PhraseSuggestionContext.DirectCandidateGenerator> generators = suggestion.generators();
        int numGenerators = generators.size();
        ArrayList<DirectCandidateGenerator> gens = new ArrayList<DirectCandidateGenerator>(generators.size());
        for (int i = 0; i < numGenerators; ++i) {
            PhraseSuggestionContext.DirectCandidateGenerator generator = generators.get(i);
            DirectSpellChecker directSpellChecker = generator.createDirectSpellChecker();
            Terms terms = MultiTerms.getTerms((IndexReader)indexReader, (String)generator.field());
            if (terms == null) continue;
            gens.add(new DirectCandidateGenerator(directSpellChecker, generator.field(), generator.suggestMode(), indexReader, realWordErrorLikelihood, generator.size(), generator.preFilter(), generator.postFilter(), terms));
        }
        String suggestField = suggestion.getField();
        Terms suggestTerms = MultiTerms.getTerms((IndexReader)indexReader, (String)suggestField);
        if (gens.size() > 0 && suggestTerms != null) {
            NoisyChannelSpellChecker.Result checkerResult;
            NoisyChannelSpellChecker checker = new NoisyChannelSpellChecker(realWordErrorLikelihood, suggestion.getRequireUnigram(), suggestion.getTokenLimit());
            BytesRef separator = suggestion.separator();
            WordScorer wordScorer = suggestion.model().newScorer(indexReader, suggestTerms, suggestField, realWordErrorLikelihood, separator);
            try (TokenStream stream = PhraseSuggester.tokenStream(suggestion.getAnalyzer(), suggestion.getText(), spare, suggestion.getField());){
                checkerResult = checker.getCorrections(stream, new MultiCandidateGeneratorWrapper(suggestion.getShardSize(), gens.toArray(new CandidateGenerator[0])), suggestion.maxErrors(), suggestion.getShardSize(), wordScorer, suggestion.confidence(), suggestion.gramSize());
            }
            PhraseSuggestion.Entry resultEntry = PhraseSuggester.buildResultEntry(suggestion, spare, checkerResult.cutoffScore);
            response.addTerm(resultEntry);
            BytesRefBuilder byteSpare = new BytesRefBuilder();
            TemplateScript.Factory scriptFactory = suggestion.getCollateQueryScript();
            boolean collatePrune = scriptFactory != null && suggestion.collatePrune();
            for (int i = 0; i < checkerResult.corrections.length; ++i) {
                Correction correction = checkerResult.corrections[i];
                spare.copyUTF8Bytes(correction.join(this.SEPARATOR, byteSpare, null, null));
                boolean collateMatch = true;
                if (scriptFactory != null) {
                    Map<String, Object> vars = suggestion.getCollateScriptParams();
                    vars.put(SUGGESTION_TEMPLATE_VAR_NAME, spare.toString());
                    QueryShardContext shardContext = suggestion.getShardContext();
                    String querySource = scriptFactory.newInstance(vars).execute();
                    try (XContentParser parser = MediaTypeRegistry.xContent(querySource).xContent().createParser(shardContext.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, querySource);){
                        QueryBuilder innerQueryBuilder = QueryBuilder.parseInnerQueryBuilder(parser);
                        ParsedQuery parsedQuery = shardContext.toQuery(innerQueryBuilder);
                        collateMatch = XLucene.exists(searcher, parsedQuery.query());
                    }
                }
                if (!collateMatch && !collatePrune) continue;
                Text phrase = new Text(spare.toString());
                Text highlighted = null;
                if (suggestion.getPreTag() != null) {
                    spare.copyUTF8Bytes(correction.join(this.SEPARATOR, byteSpare, suggestion.getPreTag(), suggestion.getPostTag()));
                    highlighted = new Text(spare.toString());
                }
                if (collatePrune) {
                    resultEntry.addOption(new PhraseSuggestion.Entry.Option(phrase, highlighted, (float)correction.score, collateMatch));
                    continue;
                }
                resultEntry.addOption(new PhraseSuggestion.Entry.Option(phrase, highlighted, (float)correction.score));
            }
        } else {
            response.addTerm(PhraseSuggester.buildResultEntry(suggestion, spare, Double.MIN_VALUE));
        }
        return response;
    }

    private static TokenStream tokenStream(Analyzer analyzer, BytesRef query, CharsRefBuilder spare, String field) throws IOException {
        spare.copyUTF8Bytes(query);
        return analyzer.tokenStream(field, (Reader)new CharArrayReader(spare.chars(), 0, spare.length()));
    }

    private static PhraseSuggestion.Entry buildResultEntry(SuggestionSearchContext.SuggestionContext suggestion, CharsRefBuilder spare, double cutoffScore) {
        spare.copyUTF8Bytes(suggestion.getText());
        return new PhraseSuggestion.Entry(new Text(spare.toString()), 0, spare.length(), cutoffScore);
    }

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> emptySuggestion(String name, PhraseSuggestionContext suggestion, CharsRefBuilder spare) throws IOException {
        PhraseSuggestion phraseSuggestion = new PhraseSuggestion(name, suggestion.getSize());
        spare.copyUTF8Bytes(suggestion.getText());
        phraseSuggestion.addTerm(new PhraseSuggestion.Entry(new Text(spare.toString()), 0, spare.length()));
        return phraseSuggestion;
    }
}

