/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.security.auth;

import io.skylite.common.Nullable;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.internal.ToStringBuilder;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class User
implements Writeable,
ToXContent {
    public static final String NAME_FIELD = "name";
    public static final String BACKEND_ROLES_FIELD = "backend_roles";
    public static final String ROLES_FIELD = "roles";
    public static final String CUSTOM_ATTRIBUTE_NAMES_FIELD = "custom_attribute_names";
    public static final String REQUESTED_TENANT_FIELD = "user_requested_tenant";
    private final String name;
    private final List<String> backendRoles;
    private final List<String> roles;
    private final List<String> customAttNames;
    @Nullable
    private final String requestedTenant;

    public User() {
        this.name = "";
        this.backendRoles = new ArrayList<String>();
        this.roles = new ArrayList<String>();
        this.customAttNames = new ArrayList<String>();
        this.requestedTenant = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, List<String> customAttNames) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttNames = customAttNames;
        this.requestedTenant = null;
    }

    public User(String name, List<String> backendRoles, List<String> roles, List<String> customAttNames, @Nullable String requestedTenant) {
        this.name = name;
        this.backendRoles = backendRoles;
        this.roles = roles;
        this.customAttNames = customAttNames;
        this.requestedTenant = requestedTenant;
    }

    public User(String json) {
        if (Strings.isNullOrEmpty(json)) {
            throw new IllegalArgumentException("Response json cannot be null");
        }
        Map<String, Object> mapValue = XContentHelper.convertToMap(MediaTypeRegistry.JSON.xContent(), json, false);
        this.name = (String)mapValue.get("user_name");
        this.backendRoles = (List)mapValue.get(BACKEND_ROLES_FIELD);
        this.roles = (List)mapValue.get(ROLES_FIELD);
        this.customAttNames = (List)mapValue.get(CUSTOM_ATTRIBUTE_NAMES_FIELD);
        this.requestedTenant = mapValue.getOrDefault(REQUESTED_TENANT_FIELD, null);
    }

    public User(StreamInput in) throws IOException {
        this.name = in.readString();
        this.backendRoles = in.readStringList();
        this.roles = in.readStringList();
        this.customAttNames = in.readStringList();
        this.requestedTenant = in.readOptionalString();
    }

    public static User parse(XContentParser parser) throws IOException {
        String name = "";
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<String> customAttNames = new ArrayList<String>();
        String requestedTenant = null;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "backend_roles": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    break;
                }
                case "roles": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        roles.add(parser.text());
                    }
                    break;
                }
                case "custom_attribute_names": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        customAttNames.add(parser.text());
                    }
                    break;
                }
                case "user_requested_tenant": {
                    requestedTenant = parser.textOrNull();
                    break;
                }
            }
        }
        return new User(name, backendRoles, roles, customAttNames, requestedTenant);
    }

    public static User parse(String userString) {
        if (Strings.isNullOrEmpty(userString)) {
            return null;
        }
        String[] strs = userString.split("\\|");
        if (strs.length == 0 || Strings.isNullOrEmpty(strs[0])) {
            return null;
        }
        String userName = strs[0].trim();
        ArrayList<String> backendRoles = new ArrayList<String>();
        ArrayList<String> roles = new ArrayList<String>();
        String requestedTenant = null;
        if (strs.length > 1 && !Strings.isNullOrEmpty(strs[1])) {
            backendRoles.addAll(Arrays.asList(strs[1].split(",")));
        }
        if (strs.length > 2 && !Strings.isNullOrEmpty(strs[2])) {
            roles.addAll(Arrays.asList(strs[2].split(",")));
        }
        if (strs.length > 3 && !Strings.isNullOrEmpty(strs[3])) {
            requestedTenant = strs[3].trim();
        }
        return new User(userName, backendRoles, roles, Arrays.asList(new String[0]), requestedTenant);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(NAME_FIELD, this.name).field(BACKEND_ROLES_FIELD, this.backendRoles).field(ROLES_FIELD, this.roles).field(CUSTOM_ATTRIBUTE_NAMES_FIELD, this.customAttNames).field(REQUESTED_TENANT_FIELD, this.requestedTenant);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.backendRoles);
        out.writeStringCollection(this.roles);
        out.writeStringCollection(this.customAttNames);
        out.writeOptionalString(this.requestedTenant);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add(NAME_FIELD, this.name);
        builder.add(BACKEND_ROLES_FIELD, this.backendRoles);
        builder.add(ROLES_FIELD, this.roles);
        builder.add(CUSTOM_ATTRIBUTE_NAMES_FIELD, this.customAttNames);
        builder.add(REQUESTED_TENANT_FIELD, this.requestedTenant);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return this.name.equals(that.name) && this.getBackendRoles().equals(that.backendRoles) && this.getRoles().equals(that.roles) && this.getCustomAttNames().equals(that.customAttNames) && Objects.equals(this.requestedTenant, that.requestedTenant);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.backendRoles, this.roles, this.customAttNames, this.requestedTenant);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getCustomAttNames() {
        return this.customAttNames;
    }

    @Nullable
    public String getRequestedTenant() {
        return this.requestedTenant;
    }

    public boolean isAdminDn(Settings settings) {
        if (settings == null) {
            return false;
        }
        List<String> adminDns = settings.getAsList("plugins.security.authcz.admin_dn", Collections.emptyList());
        return adminDns.contains(this.name);
    }
}

