/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.settings;

import io.skylite.core.common.logging.Loggers;
import io.skylite.core.index.Index;
import io.skylite.core.index.metadata.IndexMetadataSettings;
import io.skylite.core.index.similarity.SimilarityProviders;
import io.skylite.core.settings.AbstractScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class IndexScopedSettings
extends AbstractScopedSettings {
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final Predicate<String> INDEX_SETTINGS_KEY_PREDICATE = s -> s.startsWith(INDEX_SETTING_PREFIX);
    public static final Predicate<String> ARCHIVED_SETTINGS_KEY_PREDICATE = s -> s.startsWith("archived.");
    public static final Set<Setting<?>> BUILT_IN_INDEX_SETTINGS = Stream.concat(SETTINGS_REGISTRY.stream().filter(s -> s.getProperties().contains((Object)Setting.Property.IndexScope)), Stream.of(Setting.groupSetting("index.similarity.", s -> {
        Map<String, Settings> groups = s.getAsGroups();
        SimilarityProviders.BUILT_IN.keySet().stream().filter(groups::containsKey).findAny().ifPresent(key -> {
            throw new IllegalArgumentException("illegal value for [index.similarity." + key + "] cannot redefine built-in similarity");
        });
    }, Setting.Property.IndexScope), Setting.groupSetting("index.analysis.", Setting.Property.IndexScope))).collect(Collectors.toUnmodifiableSet());

    public static IndexScopedSettings getDefaultScopedSettings() {
        return DefaultScopeSettingsHolder.INSTANCE;
    }

    public IndexScopedSettings(Settings settings, Set<Setting<?>> settingsSet) {
        super(settings, settingsSet, Collections.emptySet(), Setting.Property.IndexScope);
    }

    public IndexScopedSettings(Settings settings, IndexScopedSettings other, Settings metadataSettings, Index index) {
        super(settings, metadataSettings, other, Loggers.getLogger(IndexScopedSettings.class, index, new String[0]));
    }

    protected void validateSettingKey(Setting setting) {
        if (!setting.getKey().startsWith(INDEX_SETTING_PREFIX)) {
            throw new IllegalArgumentException("illegal settings key: [" + setting.getKey() + "] must start with [index.]");
        }
        super.validateSettingKey(setting);
    }

    @Override
    public boolean isPrivateSetting(String key) {
        switch (key) {
            case "index.creation_date": 
            case "index.uuid": 
            case "index.history.uuid": 
            case "index.version.upgraded": 
            case "index.provided_name": 
            case "index.merge.enabled": 
            case "index.shrink.source.uuid": 
            case "index.shrink.source.name": 
            case "index.resize.source.uuid": 
            case "index.resize.source.name": 
            case "index.plugins.replication.translog.retention_lease.pruning.enabled": {
                return true;
            }
        }
        return IndexMetadataSettings.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getRawKey().match(key);
    }

    public static final class DefaultScopeSettingsHolder {
        public static final IndexScopedSettings INSTANCE = new IndexScopedSettings(Settings.EMPTY, BUILT_IN_INDEX_SETTINGS);
    }
}

