/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.snapshots;

import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInUseDeletionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SnapshotUtils {
    public static List<String> filterIndices(List<String> availableIndices, String[] selectedIndices, IndicesOptions indicesOptions) {
        if (IndexNameExpressionResolver.isAllIndices(Arrays.asList(selectedIndices))) {
            return availableIndices;
        }
        List excludesAtEndSelectedIndices = Stream.concat(Arrays.stream(selectedIndices).filter(s -> s.isEmpty() || s.charAt(0) != '-'), Arrays.stream(selectedIndices).filter(s -> !s.isEmpty() && s.charAt(0) == '-')).collect(Collectors.toUnmodifiableList());
        HashSet<Object> result = null;
        for (int i = 0; i < excludesAtEndSelectedIndices.size(); ++i) {
            String indexOrPattern = (String)excludesAtEndSelectedIndices.get(i);
            boolean add = true;
            if (!indexOrPattern.isEmpty()) {
                if (availableIndices.contains(indexOrPattern)) {
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(indexOrPattern);
                    continue;
                }
                if (indexOrPattern.charAt(0) == '+') {
                    add = true;
                    indexOrPattern = indexOrPattern.substring(1);
                    if (i == 0) {
                        result = new HashSet();
                    }
                } else if (indexOrPattern.charAt(0) == '-') {
                    if (i == 0) {
                        result = new HashSet<String>(availableIndices);
                    }
                    add = false;
                    indexOrPattern = indexOrPattern.substring(1);
                }
            }
            if (indexOrPattern.isEmpty() || !Regex.isSimpleMatchPattern(indexOrPattern)) {
                if (!availableIndices.contains(indexOrPattern)) {
                    if (!indicesOptions.ignoreUnavailable()) {
                        throw new IndexNotFoundException(indexOrPattern);
                    }
                    if (result != null) continue;
                    result = new HashSet<String>(availableIndices.subList(0, i));
                    continue;
                }
                if (result == null) continue;
                if (add) {
                    result.add(indexOrPattern);
                    continue;
                }
                result.remove(indexOrPattern);
                continue;
            }
            if (result == null) {
                result = new HashSet<String>(availableIndices.subList(0, i));
            }
            boolean found = false;
            for (String index : availableIndices) {
                if (!Regex.simpleMatch(indexOrPattern, index)) continue;
                found = true;
                if (add) {
                    result.add(index);
                    continue;
                }
                result.remove(index);
            }
            if (found || indicesOptions.allowNoIndices()) continue;
            throw new IndexNotFoundException(indexOrPattern);
        }
        if (result == null) {
            return Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(selectedIndices)));
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }

    public static void validateSnapshotsBackingAnyIndex(Map<String, IndexMetadata> metadata, List<SnapshotId> snapshotIds, String repoName) {
        HashMap uuidToSnapshotId = new HashMap();
        HashSet<String> snapshotsToBeNotDeleted = new HashSet<String>();
        snapshotIds.forEach(snapshotId -> uuidToSnapshotId.put(snapshotId.getUUID(), snapshotId));
        for (IndexMetadata indexMetadata : metadata.values()) {
            String snapshotId2;
            String storeType = indexMetadata.getSettings().get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey());
            if (!IndexModuleSettings.Type.REMOTE_SNAPSHOT.match(storeType) || uuidToSnapshotId.get(snapshotId2 = indexMetadata.getSettings().get(IndexSettings.SEARCHABLE_SNAPSHOT_ID_UUID.getKey())) == null) continue;
            snapshotsToBeNotDeleted.add(((SnapshotId)uuidToSnapshotId.get(snapshotId2)).getName());
        }
        if (!snapshotsToBeNotDeleted.isEmpty()) {
            throw new SnapshotInUseDeletionException(repoName, ((Object)snapshotsToBeNotDeleted).toString(), "These remote snapshots are backing some indices and hence can't be deleted! No snapshots were deleted.");
        }
    }
}

