/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks;

import io.skylite.Version;
import io.skylite.common.action.ActionListener;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.TaskResult;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;

public abstract class BaseTaskResultsService {
    public static final String TASK_INDEX = ".tasks";
    public static final String TASK_RESULT_MAPPING_VERSION_META_FIELD = "version";
    public static final SystemIndexDescriptor TASKS_DESCRIPTOR = SystemIndexDescriptor.builder().setIndexPattern(".tasks*").setPrimaryIndex(".tasks").setDescription("Task Result Index").setSettings(BaseTaskResultsService.getTaskResultIndexSettings()).setMappings(BaseTaskResultsService.getTaskResultIndexMappings()).setVersionMetaKey("version").setOrigin("tasks").build();

    private static Settings getTaskResultIndexSettings() {
        return Settings.builder().put(IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getKey(), 1).put("index.auto_expand_replicas", "0-1").put("index.priority", Integer.MAX_VALUE).build();
    }

    private static XContentBuilder getTaskResultIndexMappings() {
        try {
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field(TASK_RESULT_MAPPING_VERSION_META_FIELD, Version.CURRENT.toString());
            builder.endObject();
            builder.field("dynamic", "true");
            builder.startObject("properties");
            builder.startObject("completed");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("task");
            builder.startObject("properties");
            builder.startObject("action");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("cancellable");
            builder.field("type", "boolean");
            builder.endObject();
            builder.startObject("id");
            builder.field("type", "long");
            builder.endObject();
            builder.startObject("parent_task_id");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("node");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("running_time_in_nanos");
            builder.field("type", "long");
            builder.endObject();
            builder.startObject("start_time_in_millis");
            builder.field("type", "long");
            builder.endObject();
            builder.startObject("type");
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject("status");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("description");
            builder.field("type", "text");
            builder.endObject();
            builder.startObject("headers");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject("response");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.startObject("error");
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build .tasks index mappings", e);
        }
    }

    public abstract void storeResult(TaskResult var1, ActionListener<Void> var2);
}

