/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks;

import io.skylite.common.Nullable;
import io.skylite.common.SetOnce;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import java.util.Map;

public abstract class CancellableTask
extends Task {
    private final SetOnce<CancelledInfo> cancelledInfo = new SetOnce();
    private final TimeValue cancelAfterTimeInterval;

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, description, parentTaskId, headers, TimeValue.NO_TIMEOUT);
    }

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        super(id, type, action, description, parentTaskId, headers);
        this.cancelAfterTimeInterval = cancelAfterTimeInterval;
    }

    public void cancel(String reason) {
        assert (reason != null);
        if (this.cancelledInfo.trySet((Object)new CancelledInfo(reason))) {
            this.onCancelled();
        }
    }

    public boolean isCancelled() {
        return this.cancelledInfo.get() != null;
    }

    public abstract boolean shouldCancelChildrenOnCancellation();

    public TimeValue getCancellationTimeout() {
        return this.cancelAfterTimeInterval;
    }

    protected void onCancelled() {
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    @Nullable
    public Long getCancellationStartTime() {
        CancelledInfo info = (CancelledInfo)this.cancelledInfo.get();
        return info != null ? info.cancellationStartTime : null;
    }

    @Nullable
    public Long getCancellationStartTimeNanos() {
        CancelledInfo info = (CancelledInfo)this.cancelledInfo.get();
        return info != null ? info.cancellationStartTimeNanos : null;
    }

    @Nullable
    public String getReasonCancelled() {
        CancelledInfo info = (CancelledInfo)this.cancelledInfo.get();
        return info != null ? info.reason : null;
    }

    private static class CancelledInfo {
        String reason;
        Long cancellationStartTime;
        Long cancellationStartTimeNanos;

        public CancelledInfo(String reason) {
            this.reason = reason;
            this.cancellationStartTime = System.currentTimeMillis();
            this.cancellationStartTimeNanos = System.nanoTime();
        }
    }
}

