/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks;

import io.skylite.SkyliteParseException;
import io.skylite.common.annotation.PublicApi;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

@PublicApi(since="1.0.0")
public final class TaskId
implements Writeable {
    public static final TaskId EMPTY_TASK_ID = new TaskId();
    public static final String TASK_ID = "TASK_ID";
    private final String nodeId;
    private final long id;

    public TaskId(String nodeId, long id) {
        if (nodeId.isEmpty()) {
            throw new IllegalArgumentException("0 length nodeIds are reserved for EMPTY_TASK_ID and are otherwise invalid.");
        }
        this.nodeId = nodeId;
        this.id = id;
    }

    private TaskId() {
        this.nodeId = "";
        this.id = -1L;
    }

    public TaskId(String taskId) {
        if (Strings.hasLength(taskId) && !"unset".equals(taskId)) {
            String[] s = Strings.split(taskId, ":");
            if (s == null || s.length != 2) {
                throw new IllegalArgumentException("malformed task id " + taskId);
            }
            this.nodeId = s[0];
            try {
                this.id = Long.parseLong(s[1]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("malformed task id " + taskId, ex);
            }
        } else {
            this.nodeId = "";
            this.id = -1L;
        }
    }

    public static TaskId readFromStream(StreamInput in) throws IOException {
        String nodeId = in.readString();
        if (nodeId.isEmpty()) {
            return EMPTY_TASK_ID;
        }
        return new TaskId(nodeId, in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        if (this.nodeId.isEmpty()) {
            return;
        }
        out.writeLong(this.id);
    }

    public static ContextParser<Void, TaskId> parser() {
        return (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new TaskId(p.text());
            }
            throw new SkyliteParseException("Expected a string but found [{}] instead", new Object[]{p.currentToken()});
        };
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSet() {
        return this.id != -1L;
    }

    public String toString() {
        if (this.isSet()) {
            return this.nodeId + ":" + this.id;
        }
        return "unset";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        if (this.id != taskId.id) {
            return false;
        }
        return this.nodeId.equals(taskId.nodeId);
    }

    public int hashCode() {
        int result = this.nodeId.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }
}

