/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteTimeoutException;
import io.skylite.common.Assertions;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.SetOnce;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.ConcurrentMapLong;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.state.ClusterStateApplier;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.http.HttpTransportSettings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.tasks.BaseTaskResultsService;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskAwareRequest;
import io.skylite.core.tasks.TaskCancellationService;
import io.skylite.core.tasks.TaskCancelledException;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.tasks.TaskResourceTrackingService;
import io.skylite.core.tasks.TaskResult;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TcpChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TaskManager
implements ClusterStateApplier {
    public static final String TASKS_ORIGIN = "tasks";
    private static final Logger logger = LogManager.getLogger(TaskManager.class);
    private static final TimeValue WAIT_FOR_COMPLETION_POLL = TimeValue.timeValueMillis((long)100L);
    public static final String TASK_RESOURCE_CONSUMERS_ATTRIBUTES = "task_resource_consumers.enabled";
    public static final Setting<Boolean> TASK_RESOURCE_CONSUMERS_ENABLED = Setting.boolSetting("task_resource_consumers.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final List<String> taskHeaders;
    private final ThreadPool threadPool;
    private final ConcurrentMapLong<Task> tasks = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final ConcurrentMapLong<CancellableTaskHolder> cancellableTasks = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final AtomicLong taskIdGenerator = new AtomicLong();
    private final Map<TaskId, String> banedParents = new ConcurrentHashMap<TaskId, String>();
    private BaseTaskResultsService taskResultsService;
    private final SetOnce<TaskResourceTrackingService> taskResourceTrackingService = new SetOnce();
    private volatile DiscoveryNodes lastDiscoveryNodes = DiscoveryNodes.EMPTY_NODES;
    private final ByteSizeValue maxHeaderSize;
    private final Map<TcpChannel, ChannelPendingTaskTracker> channelPendingTaskTrackers = ConcurrentCollections.newConcurrentMap();
    private final SetOnce<TaskCancellationService> cancellationService = new SetOnce();
    private volatile boolean taskResourceConsumersEnabled;
    private final Set<Consumer<Task>> taskResourceConsumer;
    private final List<TaskEventListeners> taskEventListeners = new ArrayList<TaskEventListeners>();

    public static TaskManager createTaskManagerWithClusterSettings(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, Set<String> taskHeaders) {
        TaskManager taskManager = new TaskManager(settings, threadPool, taskHeaders);
        clusterSettings.addSettingsUpdateConsumer(TASK_RESOURCE_CONSUMERS_ENABLED, taskManager::setTaskResourceConsumersEnabled);
        return taskManager;
    }

    public TaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        this.threadPool = threadPool;
        this.taskHeaders = new ArrayList<String>(taskHeaders);
        this.maxHeaderSize = HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.taskResourceConsumersEnabled = TASK_RESOURCE_CONSUMERS_ENABLED.get(settings);
        this.taskResourceConsumer = new HashSet<Consumer<Task>>();
    }

    public void addTaskEventListeners(TaskEventListeners taskEventListeners) {
        this.taskEventListeners.add(taskEventListeners);
    }

    public void registerTaskResourceConsumer(Consumer<Task> consumer) {
        this.taskResourceConsumer.add(consumer);
    }

    public void setTaskResultsService(BaseTaskResultsService taskResultsService) {
        assert (this.taskResultsService == null);
        this.taskResultsService = taskResultsService;
    }

    public void setTaskCancellationService(TaskCancellationService taskCancellationService) {
        this.cancellationService.set((Object)taskCancellationService);
    }

    public void setTaskResourceTrackingService(TaskResourceTrackingService taskResourceTrackingService) {
        this.taskResourceTrackingService.set((Object)taskResourceTrackingService);
    }

    public void setTaskResourceConsumersEnabled(boolean taskResourceConsumersEnabled) {
        this.taskResourceConsumersEnabled = taskResourceConsumersEnabled;
    }

    public Task register(String type, String action, TaskAwareRequest request) {
        boolean success;
        HashMap<String, String> headers = new HashMap<String, String>();
        long headerSize = 0L;
        long maxSize = this.maxHeaderSize.getBytes();
        ThreadContext threadContext = this.threadPool.getThreadContext();
        for (String key : this.taskHeaders) {
            String httpHeader = threadContext.getHeader(key);
            if (httpHeader == null) continue;
            if ((headerSize += (long)(key.length() * 2 + httpHeader.length() * 2)) > maxSize) {
                throw new IllegalArgumentException("Request exceeded the maximum size of task headers " + String.valueOf(this.maxHeaderSize));
            }
            headers.put(key, httpHeader);
        }
        Task task = request.createTask(this.taskIdGenerator.incrementAndGet(), type, action, request.getParentTask(), headers);
        Objects.requireNonNull(task);
        assert (task.getParentTaskId().equals(request.getParentTask())) : "Request [ " + String.valueOf(request) + "] didn't preserve it parentTaskId";
        if (logger.isTraceEnabled()) {
            logger.trace("register {} [{}] [{}] [{}]", (Object)task.getId(), (Object)type, (Object)action, (Object)task.getDescription());
        }
        if (task.supportsResourceTracking() && !(success = task.addResourceTrackingCompletionListener(new NotifyOnceListener<Task>(){

            protected void innerOnResponse(Task task) {
                if (TaskManager.this.taskResourceTrackingService.get() != null && task.supportsResourceTracking()) {
                    ((TaskResourceTrackingService)TaskManager.this.taskResourceTrackingService.get()).stopTracking(task);
                }
            }

            protected void innerOnFailure(Exception e) {
                ExceptionsHelper.reThrowIfNotNull((Throwable)e);
            }
        }))) {
            logger.debug("failed to register a completion listener as task resource tracking has already completed [taskId={}]", (Object)task.getId());
        }
        if (task instanceof CancellableTask) {
            this.registerCancellableTask(task);
        } else {
            Task previousTask = (Task)this.tasks.put(task.getId(), (Object)task);
            assert (previousTask == null);
        }
        return task;
    }

    private void registerCancellableTask(Task task) {
        String reason;
        CancellableTask cancellableTask = (CancellableTask)task;
        CancellableTaskHolder holder = new CancellableTaskHolder(cancellableTask);
        CancellableTaskHolder oldHolder = (CancellableTaskHolder)this.cancellableTasks.put(task.getId(), (Object)holder);
        assert (oldHolder == null);
        if (task.getParentTaskId().isSet() && !this.banedParents.isEmpty() && (reason = this.banedParents.get(task.getParentTaskId())) != null) {
            try {
                holder.cancel(reason);
                throw new TaskCancelledException("Task cancelled before it started: " + reason);
            }
            catch (Throwable throwable) {
                this.unregister(task);
                throw throwable;
            }
        }
    }

    public void cancel(CancellableTask task, String reason, Runnable listener) {
        CancellableTaskHolder holder = (CancellableTaskHolder)this.cancellableTasks.get(task.getId());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (TaskEventListeners taskEventListener : this.taskEventListeners) {
            try {
                taskEventListener.onTaskCancelled(task);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        if (holder != null) {
            logger.trace("cancelling task with id {}", (Object)task.getId());
            holder.cancel(reason, listener);
        } else {
            listener.run();
        }
    }

    public Task unregister(Task task) {
        logger.trace("unregister task for id: {}", (Object)task.getId());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (TaskEventListeners taskEventListeners : this.taskEventListeners) {
            try {
                taskEventListeners.onTaskCompleted(task);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        task.decrementResourceTrackingThreads();
        if (this.taskResourceConsumersEnabled) {
            for (Consumer consumer : this.taskResourceConsumer) {
                try {
                    consumer.accept(task);
                }
                catch (Exception e) {
                    logger.error("error encountered when updating the consumer", (Throwable)e);
                }
            }
        }
        if (task instanceof CancellableTask) {
            CancellableTaskHolder holder = (CancellableTaskHolder)this.cancellableTasks.remove(task.getId());
            if (holder != null) {
                holder.finish();
                return holder.getTask();
            }
            return null;
        }
        return (Task)this.tasks.remove(task.getId());
    }

    public Releasable registerChildNode(long taskId, DiscoveryNode node) {
        CancellableTaskHolder holder = (CancellableTaskHolder)this.cancellableTasks.get(taskId);
        if (holder != null) {
            logger.trace("register child node [{}] task [{}]", (Object)node, (Object)taskId);
            holder.registerChildNode(node);
            return Releasables.releaseOnce(() -> {
                logger.trace("unregister child node [{}] task [{}]", (Object)node, (Object)taskId);
                holder.unregisterChildNode(node);
            });
        }
        return () -> {};
    }

    public DiscoveryNode localNode() {
        return this.lastDiscoveryNodes.getLocalNode();
    }

    public <Response extends ActionResponse> void storeResult(Task task, final Exception error, final ActionListener<Response> listener) {
        TaskResult taskResult;
        DiscoveryNode localNode = this.lastDiscoveryNodes.getLocalNode();
        if (localNode == null) {
            listener.onFailure(error);
            return;
        }
        try {
            taskResult = task.result(localNode.getId(), error);
        }
        catch (IOException ex) {
            logger.warn(() -> new ParameterizedMessage("couldn't store error {}", (Object)SkyliteExceptionsHelper.detailedMessage(error)), (Throwable)ex);
            listener.onFailure((Exception)ex);
            return;
        }
        this.taskResultsService.storeResult(taskResult, new ActionListener<Void>(){

            public void onResponse(Void aVoid) {
                listener.onFailure(error);
            }

            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("couldn't store error {}", (Object)SkyliteExceptionsHelper.detailedMessage(error)), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public <Response extends ActionResponse> void storeResult(Task task, final Response response, final ActionListener<Response> listener) {
        TaskResult taskResult;
        DiscoveryNode localNode = this.lastDiscoveryNodes.getLocalNode();
        if (localNode == null) {
            logger.warn("couldn't store response {}, the node didn't join the cluster yet", response);
            listener.onResponse(response);
            return;
        }
        try {
            taskResult = task.result(localNode.getId(), response);
        }
        catch (IOException ex) {
            logger.warn(() -> new ParameterizedMessage("couldn't store response {}", (Object)response), (Throwable)ex);
            listener.onFailure((Exception)ex);
            return;
        }
        this.taskResultsService.storeResult(taskResult, new ActionListener<Void>(){

            public void onResponse(Void aVoid) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("couldn't store response {}", (Object)response), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public Map<Long, Task> getTasks() {
        HashMap<Long, CancellableTask> taskHashMap = new HashMap<Long, CancellableTask>((Map<Long, CancellableTask>)this.tasks);
        for (CancellableTaskHolder holder : this.cancellableTasks.values()) {
            taskHashMap.put(holder.getTask().getId(), holder.getTask());
        }
        return Collections.unmodifiableMap(taskHashMap);
    }

    public Map<Long, CancellableTask> getCancellableTasks() {
        HashMap<Long, CancellableTask> taskHashMap = new HashMap<Long, CancellableTask>();
        for (CancellableTaskHolder holder : this.cancellableTasks.values()) {
            taskHashMap.put(holder.getTask().getId(), holder.getTask());
        }
        return Collections.unmodifiableMap(taskHashMap);
    }

    public Task getTask(long id) {
        Task task = (Task)this.tasks.get(id);
        if (task != null) {
            return task;
        }
        return this.getCancellableTask(id);
    }

    public CancellableTask getCancellableTask(long id) {
        CancellableTaskHolder holder = (CancellableTaskHolder)this.cancellableTasks.get(id);
        if (holder != null) {
            return holder.getTask();
        }
        return null;
    }

    public int getBanCount() {
        return this.banedParents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CancellableTask> setBan(TaskId parentTaskId, String reason) {
        logger.trace("setting ban for the parent task {} {}", (Object)parentTaskId, (Object)reason);
        Map<TaskId, String> map = this.banedParents;
        synchronized (map) {
            if (this.lastDiscoveryNodes.nodeExists(parentTaskId.getNodeId())) {
                this.banedParents.put(parentTaskId, reason);
            }
        }
        return this.cancellableTasks.values().stream().filter(t -> t.hasParent(parentTaskId)).map(t -> t.task).collect(Collectors.toList());
    }

    public void removeBan(TaskId parentTaskId) {
        logger.trace("removing ban for the parent task {}", (Object)parentTaskId);
        this.banedParents.remove(parentTaskId);
    }

    public Set<TaskId> getBannedTaskIds() {
        return Collections.unmodifiableSet(this.banedParents.keySet());
    }

    public Collection<DiscoveryNode> startBanOnChildrenNodes(long taskId, Runnable onChildTasksCompleted) {
        CancellableTaskHolder holder = (CancellableTaskHolder)this.cancellableTasks.get(taskId);
        if (holder != null) {
            return holder.startBan(onChildTasksCompleted);
        }
        onChildTasksCompleted.run();
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyClusterState(ClusterStateChangedEvent event) {
        this.lastDiscoveryNodes = event.state().getNodes();
        if (event.nodesRemoved()) {
            Map<TaskId, String> map = this.banedParents;
            synchronized (map) {
                this.lastDiscoveryNodes = event.state().getNodes();
                Iterator<TaskId> banIterator = this.banedParents.keySet().iterator();
                while (banIterator.hasNext()) {
                    TaskId taskId = banIterator.next();
                    if (this.lastDiscoveryNodes.nodeExists(taskId.getNodeId())) continue;
                    logger.debug("Removing ban for the parent [{}] on the node [{}], reason: the parent node is gone", (Object)taskId, (Object)event.state().getNodes().getLocalNode());
                    banIterator.remove();
                }
            }
        }
    }

    public void waitForTaskCompletion(Task task, long untilInNanos) {
        while (System.nanoTime() - untilInNanos < 0L) {
            if (this.getTask(task.getId()) == null) {
                return;
            }
            try {
                Thread.sleep(WAIT_FOR_COMPLETION_POLL.millis());
            }
            catch (InterruptedException e) {
                throw new SkyliteException("Interrupted waiting for completion of [{}]", (Throwable)e, task);
            }
        }
        throw new SkyliteTimeoutException("Timed out waiting for completion of [{}]", task);
    }

    public ThreadContext.StoredContext taskExecutionStarted(Task task) {
        if (this.taskResourceTrackingService.get() == null) {
            return () -> {};
        }
        return ((TaskResourceTrackingService)this.taskResourceTrackingService.get()).startTracking(task);
    }

    public Releasable startTrackingCancellableChannelTask(TcpChannel channel, CancellableTask task) {
        assert (this.cancellableTasks.containsKey((Object)task.getId())) : "task [" + task.getId() + "] is not registered yet";
        ChannelPendingTaskTracker tracker = this.channelPendingTaskTrackers.compute(channel, (k, curr) -> {
            if (curr == null) {
                curr = new ChannelPendingTaskTracker();
            }
            curr.addTask(task);
            return curr;
        });
        if (tracker.registered.compareAndSet(false, true)) {
            channel.addCloseListener(ActionListenerHelper.wrap(r -> {
                ChannelPendingTaskTracker removedTracker = this.channelPendingTaskTrackers.remove(channel);
                assert (removedTracker == tracker);
                this.cancelTasksOnChannelClosed(tracker.drainTasks());
            }, e -> {
                assert (false) : new AssertionError("must not be here", (Throwable)e);
            }));
        }
        return () -> tracker.removeTask(task);
    }

    final int numberOfChannelPendingTaskTrackers() {
        return this.channelPendingTaskTrackers.size();
    }

    private void cancelTasksOnChannelClosed(final Set<CancellableTask> tasks) {
        if (!tasks.isEmpty()) {
            this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    logger.warn("failed to cancel tasks on channel closed", (Throwable)e);
                }

                public void doRun() {
                    for (CancellableTask task : tasks) {
                        TaskManager.this.cancelTaskAndDescendants(task, "channel was closed", false, ActionListenerHelper.wrap(() -> {}));
                    }
                }
            });
        }
    }

    public void cancelTaskAndDescendants(CancellableTask task, String reason, boolean waitForCompletion, ActionListener<Void> listener) {
        TaskCancellationService service = (TaskCancellationService)this.cancellationService.get();
        if (service == null) {
            assert (false) : "TaskCancellationService is not initialized";
            throw new IllegalStateException("TaskCancellationService is not initialized");
        }
        service.cancelTaskAndDescendants(task, reason, waitForCompletion, listener);
    }

    private static class CancellableTaskHolder {
        private final CancellableTask task;
        private boolean finished = false;
        private List<Runnable> cancellationListeners = null;
        private Map<DiscoveryNode, Integer> childTasksPerNode = null;
        private boolean banChildren = false;
        private List<Runnable> childTaskCompletedListeners = null;

        CancellableTaskHolder(CancellableTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel(String reason, Runnable listener) {
            Runnable toRun;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                if (this.finished) {
                    assert (this.cancellationListeners == null);
                    toRun = listener;
                } else {
                    toRun = () -> {};
                    if (listener != null) {
                        if (this.cancellationListeners == null) {
                            this.cancellationListeners = new ArrayList<Runnable>();
                        }
                        this.cancellationListeners.add(listener);
                    }
                }
            }
            try {
                this.task.cancel(reason);
            }
            finally {
                if (toRun != null) {
                    toRun.run();
                }
            }
        }

        void cancel(String reason) {
            this.task.cancel(reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            List<Runnable> listeners;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                this.finished = true;
                if (this.cancellationListeners != null) {
                    listeners = this.cancellationListeners;
                    this.cancellationListeners = null;
                } else {
                    listeners = Collections.emptyList();
                }
            }
            this.notifyListeners(listeners);
        }

        private void notifyListeners(List<Runnable> listeners) {
            assert (!Thread.holdsLock(this));
            Exception rootException = null;
            for (Runnable listener : listeners) {
                try {
                    listener.run();
                }
                catch (RuntimeException inner) {
                    rootException = (Exception)ExceptionsHelper.useOrSuppress(rootException, (Throwable)inner);
                }
            }
            ExceptionsHelper.reThrowIfNotNull(rootException);
        }

        public boolean hasParent(TaskId parentTaskId) {
            return this.task.getParentTaskId().equals(parentTaskId);
        }

        public CancellableTask getTask() {
            return this.task;
        }

        synchronized void registerChildNode(DiscoveryNode node) {
            if (this.banChildren) {
                throw new TaskCancelledException("The parent task was cancelled, shouldn't start any child tasks");
            }
            if (this.childTasksPerNode == null) {
                this.childTasksPerNode = new HashMap<DiscoveryNode, Integer>();
            }
            this.childTasksPerNode.merge(node, 1, Integer::sum);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterChildNode(DiscoveryNode node) {
            List<Runnable> listeners;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                if (this.childTasksPerNode.merge(node, -1, Integer::sum) == 0) {
                    this.childTasksPerNode.remove(node);
                }
                if (this.childTasksPerNode.isEmpty() && this.childTaskCompletedListeners != null) {
                    listeners = this.childTaskCompletedListeners;
                    this.childTaskCompletedListeners = null;
                } else {
                    listeners = Collections.emptyList();
                }
            }
            this.notifyListeners(listeners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<DiscoveryNode> startBan(Runnable onChildTasksCompleted) {
            Runnable toRun;
            Set<Object> pendingChildNodes;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                this.banChildren = true;
                pendingChildNodes = this.childTasksPerNode == null ? Collections.emptySet() : Set.copyOf(this.childTasksPerNode.keySet());
                if (pendingChildNodes.isEmpty()) {
                    assert (this.childTaskCompletedListeners == null);
                    toRun = onChildTasksCompleted;
                } else {
                    toRun = () -> {};
                    if (this.childTaskCompletedListeners == null) {
                        this.childTaskCompletedListeners = new ArrayList<Runnable>();
                    }
                    this.childTaskCompletedListeners.add(onChildTasksCompleted);
                }
            }
            toRun.run();
            return pendingChildNodes;
        }
    }

    public static interface TaskEventListeners {
        default public void onTaskCancelled(CancellableTask task) {
        }

        default public void onTaskCompleted(Task task) {
        }
    }

    private static class ChannelPendingTaskTracker {
        final AtomicBoolean registered = new AtomicBoolean();
        final Semaphore permits = Assertions.ENABLED ? new Semaphore(Integer.MAX_VALUE) : null;
        final Set<CancellableTask> pendingTasks = ConcurrentCollections.newConcurrentSet();

        private ChannelPendingTaskTracker() {
        }

        void addTask(CancellableTask task) {
            assert (this.permits.tryAcquire()) : "tracker was drained";
            boolean added = this.pendingTasks.add(task);
            assert (added) : "task " + task.getId() + " is in the pending list already";
            assert (this.releasePermit());
        }

        boolean acquireAllPermits() {
            this.permits.acquireUninterruptibly(Integer.MAX_VALUE);
            return true;
        }

        boolean releasePermit() {
            this.permits.release();
            return true;
        }

        Set<CancellableTask> drainTasks() {
            assert (this.acquireAllPermits());
            return Collections.unmodifiableSet(this.pendingTasks);
        }

        void removeTask(CancellableTask task) {
            boolean removed = this.pendingTasks.remove(task);
            assert (removed) : "task " + task.getId() + " is not in the pending list";
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(TASK_RESOURCE_CONSUMERS_ENABLED);
        }
    }
}

