/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.tasks.resourcetracker;

import io.skylite.core.ParseField;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;

public class TaskThreadUsage
implements Writeable,
ToXContentFragment {
    private static final String THREAD_EXECUTIONS = "thread_executions";
    private static final String ACTIVE_THREADS = "active_threads";
    private static final ParseField THREAD_EXECUTION_COUNT = new ParseField("thread_executions", new String[0]);
    private static final ParseField ACTIVE_THREAD_COUNT = new ParseField("active_threads", new String[0]);
    private final int threadExecutions;
    private final int activeThreads;
    public static final ConstructingObjectParser<TaskThreadUsage, Void> PARSER = new ConstructingObjectParser("task_thread_executions", a -> new TaskThreadUsage((Integer)a[0], (Integer)a[1]));

    public TaskThreadUsage(int threadExecutions, int activeThreads) {
        this.threadExecutions = threadExecutions;
        this.activeThreads = activeThreads;
    }

    public static TaskThreadUsage readFromStream(StreamInput in) throws IOException {
        return new TaskThreadUsage(in.readInt(), in.readInt());
    }

    public int getThreadExecutions() {
        return this.threadExecutions;
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(THREAD_EXECUTIONS, this.threadExecutions);
        builder.field(ACTIVE_THREADS, this.activeThreads);
        return builder;
    }

    public static TaskThreadUsage fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.threadExecutions);
        out.writeInt(this.activeThreads);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskThreadUsage.class) {
            return false;
        }
        TaskThreadUsage other = (TaskThreadUsage)obj;
        return Objects.equals(this.threadExecutions, other.threadExecutions) && Objects.equals(this.activeThreads, other.activeThreads);
    }

    public int hashCode() {
        return Objects.hash(this.threadExecutions, this.activeThreads);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), THREAD_EXECUTION_COUNT);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), ACTIVE_THREAD_COUNT);
    }
}

