/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.telemetry.metrics.tags;

import io.skylite.common.annotation.ExperimentalApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ExperimentalApi
public class Tags {
    private final Map<String, Object> tagsMap;
    public static final Tags EMPTY = new Tags(Collections.emptyMap());

    public static Tags create() {
        return new Tags(new HashMap<String, Object>());
    }

    private Tags(Map<String, Object> tagsMap) {
        this.tagsMap = tagsMap;
    }

    public Tags addTag(String key, String value) {
        Objects.requireNonNull(value, "value cannot be null");
        this.tagsMap.put(key, value);
        return this;
    }

    public Tags addTag(String key, long value) {
        this.tagsMap.put(key, value);
        return this;
    }

    public Tags addTag(String key, double value) {
        this.tagsMap.put(key, value);
        return this;
    }

    public Tags addTag(String key, boolean value) {
        this.tagsMap.put(key, value);
        return this;
    }

    public Map<String, ?> getTagsMap() {
        return Collections.unmodifiableMap(this.tagsMap);
    }
}

