/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.telemetry.tracing.handler;

import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import java.io.IOException;
import java.util.Objects;

public class TraceableTransportResponseHandler<T extends TransportResponse>
implements TransportResponseHandler<T> {
    private final Span span;
    private final TransportResponseHandler<T> delegate;
    private final Tracer tracer;

    private TraceableTransportResponseHandler(TransportResponseHandler<T> delegate, Span span, Tracer tracer) {
        this.delegate = Objects.requireNonNull(delegate);
        this.span = Objects.requireNonNull(span);
        this.tracer = Objects.requireNonNull(tracer);
    }

    public static <S extends TransportResponse> TransportResponseHandler<S> create(TransportResponseHandler<S> delegate, Span span, Tracer tracer) {
        if (tracer.isRecording()) {
            return new TraceableTransportResponseHandler<S>(delegate, span, tracer);
        }
        return delegate;
    }

    @Override
    public T read(StreamInput in) throws IOException {
        return (T)((TransportResponse)this.delegate.read(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(T response) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.handleResponse(response);
        }
        finally {
            this.span.endSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(TransportException exp) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.handleException(exp);
        }
        finally {
            this.span.setError((Exception)exp);
            this.span.endSpan();
        }
    }

    @Override
    public String executor() {
        return this.delegate.executor();
    }

    public String toString() {
        return this.delegate.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRejection(Exception exp) {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.handleRejection(exp);
        }
        finally {
            this.span.setError(exp);
            this.span.endSpan();
        }
    }
}

