/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.threadpool;

import io.skylite.common.threadpool.RunnableTaskExecutionListener;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.SkyliteThreadPoolExecutor;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.unit.SizeValue;
import io.skylite.core.settings.CommonSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.ThreadPool;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

public final class ResizableExecutorBuilder
extends ExecutorBuilder<ResizableExecutorSettings> {
    private final Setting<Integer> sizeSetting;
    private final Setting<Integer> queueSizeSetting;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;

    ResizableExecutorBuilder(Settings settings, String name, int size, int queueSize, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        this(settings, name, size, queueSize, "thread_pool." + name, runnableTaskListener);
    }

    public ResizableExecutorBuilder(Settings settings, String name, int size, int queueSize, String prefix, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        super(name);
        String sizeKey = ResizableExecutorBuilder.settingsKey(prefix, "size");
        this.sizeSetting = new Setting<Integer>(sizeKey, s -> Integer.toString(size), s -> Setting.parseInt(s, 1, this.applyHardSizeLimit(settings, name), sizeKey), Setting.Property.NodeScope);
        String queueSizeKey = ResizableExecutorBuilder.settingsKey(prefix, "queue_size");
        this.queueSizeSetting = Setting.intSetting(queueSizeKey, queueSize, Setting.Property.NodeScope, Setting.Property.Dynamic);
        this.runnableTaskListener = runnableTaskListener;
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.sizeSetting, this.queueSizeSetting);
    }

    @Override
    ResizableExecutorSettings getSettings(Settings settings) {
        String nodeName = CommonSettings.NODE_NAME_SETTING.get(settings);
        int size = this.sizeSetting.get(settings);
        int queueSize = this.queueSizeSetting.get(settings);
        return new ResizableExecutorSettings(nodeName, size, queueSize);
    }

    @Override
    ThreadPool.ExecutorHolder build(ResizableExecutorSettings settings, ThreadContext threadContext) {
        int size = settings.size;
        int queueSize = settings.queueSize;
        ThreadFactory threadFactory = SkyliteExecutors.daemonThreadFactory(SkyliteExecutors.threadName(settings.nodeName, this.name()));
        SkyliteThreadPoolExecutor executor = SkyliteExecutors.newResizable(settings.nodeName + "/" + this.name(), size, queueSize, threadFactory, threadContext, this.runnableTaskListener);
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.RESIZABLE, size, size, null, queueSize < 0 ? null : new SizeValue(queueSize));
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], size [%d], queue size [%s]", info.getName(), info.getMax(), info.getQueueSize() == null ? "unbounded" : info.getQueueSize());
    }

    static class ResizableExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        private final int size;
        private final int queueSize;

        ResizableExecutorSettings(String nodeName, int size, int queueSize) {
            super(nodeName);
            this.size = size;
            this.queueSize = queueSize;
        }
    }
}

