/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.AbstractRefCounted;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.RunOnce;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.concurrent.ListenableFuture;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.ConnectionManager;
import io.skylite.core.transport.ConnectionProfile;
import io.skylite.core.transport.NodeNotConnectedException;
import io.skylite.core.transport.Transport;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportConnectionListener;
import io.skylite.core.transport.Transports;
import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterConnectionManager
implements ConnectionManager {
    private static final Logger logger = LogManager.getLogger(ClusterConnectionManager.class);
    private final ConcurrentMap<DiscoveryNode, TransportConnection> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<DiscoveryNode, ListenableFuture<Void>> pendingConnections = ConcurrentCollections.newConcurrentMap();
    private final AbstractRefCounted connectingRefCounter = new AbstractRefCounted("connection manager"){

        protected void closeInternal() {
            Iterator iterator = ClusterConnectionManager.this.connectedNodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                try {
                    IOUtils.closeWhileHandlingException((Closeable)((Closeable)next.getValue()));
                }
                finally {
                    iterator.remove();
                }
            }
            ClusterConnectionManager.this.closeLatch.countDown();
        }
    };
    private final Transport transport;
    private final ConnectionProfile defaultProfile;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final ConnectionManager.DelegatingNodeConnectionListener connectionListener = new ConnectionManager.DelegatingNodeConnectionListener();

    public ClusterConnectionManager(Settings settings, Transport transport) {
        this(ConnectionProfile.buildDefaultConnectionProfile(settings), transport);
    }

    public ClusterConnectionManager(ConnectionProfile connectionProfile, Transport transport) {
        this.transport = transport;
        this.defaultProfile = connectionProfile;
    }

    @Override
    public void addListener(TransportConnectionListener listener) {
        this.connectionListener.addListener(listener);
    }

    @Override
    public void removeListener(TransportConnectionListener listener) {
        this.connectionListener.removeListener(listener);
    }

    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<TransportConnection> listener) {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        this.internalOpenConnection(node, resolvedProfile, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        ConnectionProfile resolvedProfile = ConnectionProfile.resolveConnectionProfile(connectionProfile, this.defaultProfile);
        if (node == null) {
            listener.onFailure((Exception)new ConnectTransportException(null, "can't connect to a null node"));
            return;
        }
        if (!this.connectingRefCounter.tryIncRef()) {
            listener.onFailure((Exception)new IllegalStateException("connection manager is closed"));
            return;
        }
        if (this.connectedNodes.containsKey(node)) {
            this.connectingRefCounter.decRef();
            listener.onResponse(null);
            return;
        }
        ListenableFuture<Void> currentListener = new ListenableFuture<Void>();
        ListenableFuture<Void> existingListener = this.pendingConnections.putIfAbsent(node, currentListener);
        if (existingListener != null) {
            try {
                existingListener.addListener(listener, SkyliteExecutors.newDirectExecutorService());
            }
            finally {
                this.connectingRefCounter.decRef();
            }
            return;
        }
        currentListener.addListener(listener, SkyliteExecutors.newDirectExecutorService());
        RunOnce releaseOnce = new RunOnce(() -> ((AbstractRefCounted)this.connectingRefCounter).decRef());
        this.internalOpenConnection(node, resolvedProfile, ActionListenerHelper.wrap(conn -> connectionValidator.validate((TransportConnection)conn, resolvedProfile, (ActionListener<Void>)ActionListenerHelper.wrap(ignored -> {
            block9: {
                assert (Transports.assertNotTransportThread("connection validator success"));
                try {
                    if (this.connectedNodes.putIfAbsent(node, (TransportConnection)conn) != null) {
                        logger.debug("existing connection to node [{}], closing new redundant connection", (Object)node);
                        IOUtils.closeWhileHandlingException((Closeable)conn);
                        break block9;
                    }
                    logger.debug("connected to node [{}]", (Object)node);
                    try {
                        this.connectionListener.onNodeConnected(node, (TransportConnection)conn);
                    }
                    finally {
                        TransportConnection finalConnection = conn;
                        conn.addCloseListener(ActionListenerHelper.wrap(() -> {
                            logger.trace("unregistering {} after connection close and marking as disconnected", (Object)node);
                            this.connectedNodes.remove(node, finalConnection);
                            this.connectionListener.onNodeDisconnected(node, (TransportConnection)conn);
                        }));
                    }
                }
                finally {
                    ListenableFuture future = (ListenableFuture)this.pendingConnections.remove(node);
                    assert (future == currentListener) : "Listener in pending map is different than the expected listener";
                    releaseOnce.run();
                    future.onResponse(null);
                }
            }
        }, e -> {
            assert (Transports.assertNotTransportThread("connection validator failure"));
            IOUtils.closeWhileHandlingException((Closeable)conn);
            this.failConnectionListeners(node, releaseOnce, (Exception)e, currentListener);
        })), e -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection failure"));
            this.failConnectionListeners(node, releaseOnce, (Exception)e, currentListener);
        }));
    }

    @Override
    public TransportConnection getConnection(DiscoveryNode node) {
        TransportConnection connection = (TransportConnection)this.connectedNodes.get(node);
        if (connection == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return connection;
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        TransportConnection nodeChannels = (TransportConnection)this.connectedNodes.remove(node);
        if (nodeChannels != null) {
            nodeChannels.close();
        }
    }

    @Override
    public int size() {
        return this.connectedNodes.size();
    }

    @Override
    public Set<DiscoveryNode> getAllConnectedNodes() {
        return Collections.unmodifiableSet(this.connectedNodes.keySet());
    }

    @Override
    public void close() {
        this.internalClose(true);
    }

    @Override
    public void closeNoBlock() {
        this.internalClose(false);
    }

    private void internalClose(boolean waitForPendingConnections) {
        assert (Transports.assertNotTransportThread("Closing ConnectionManager"));
        if (this.closing.compareAndSet(false, true)) {
            this.connectingRefCounter.decRef();
            if (waitForPendingConnections) {
                try {
                    this.closeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void internalOpenConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<TransportConnection> listener) {
        this.transport.openConnection(node, connectionProfile, ActionListenerHelper.map(listener, connection -> {
            assert (Transports.assertNotTransportThread("internalOpenConnection success"));
            try {
                this.connectionListener.onConnectionOpened((TransportConnection)connection);
            }
            finally {
                connection.addCloseListener(ActionListenerHelper.wrap(() -> this.connectionListener.onConnectionClosed((TransportConnection)connection)));
            }
            if (connection.isClosed()) {
                throw new ConnectTransportException(node, "a channel closed while connecting");
            }
            return connection;
        }));
    }

    private void failConnectionListeners(DiscoveryNode node, RunOnce releaseOnce, Exception e, ListenableFuture<Void> expectedListener) {
        ListenableFuture future = (ListenableFuture)this.pendingConnections.remove(node);
        releaseOnce.run();
        if (future != null) {
            assert (future == expectedListener) : "Listener in pending map is different than the expected listener";
            future.onFailure(e);
        }
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.defaultProfile;
    }
}

