/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.transport.ConnectTransportException;
import io.skylite.core.transport.ConnectionProfile;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportConnectionListener;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public interface ConnectionManager
extends Closeable {
    public void addListener(TransportConnectionListener var1);

    public void removeListener(TransportConnectionListener var1);

    public void openConnection(DiscoveryNode var1, ConnectionProfile var2, ActionListener<TransportConnection> var3);

    public void connectToNode(DiscoveryNode var1, ConnectionProfile var2, ConnectionValidator var3, ActionListener<Void> var4) throws ConnectTransportException;

    public TransportConnection getConnection(DiscoveryNode var1);

    public boolean nodeConnected(DiscoveryNode var1);

    public void disconnectFromNode(DiscoveryNode var1);

    public Set<DiscoveryNode> getAllConnectedNodes();

    public int size();

    @Override
    public void close();

    public void closeNoBlock();

    public ConnectionProfile getConnectionProfile();

    public static final class DelegatingNodeConnectionListener
    implements TransportConnectionListener {
        private final CopyOnWriteArrayList<TransportConnectionListener> listeners = new CopyOnWriteArrayList();

        @Override
        public void onNodeDisconnected(DiscoveryNode key, TransportConnection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeDisconnected(key, connection);
            }
        }

        @Override
        public void onNodeConnected(DiscoveryNode node, TransportConnection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onNodeConnected(node, connection);
            }
        }

        @Override
        public void onConnectionOpened(TransportConnection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionOpened(connection);
            }
        }

        @Override
        public void onConnectionClosed(TransportConnection connection) {
            for (TransportConnectionListener listener : this.listeners) {
                listener.onConnectionClosed(connection);
            }
        }

        public void addListener(TransportConnectionListener listener) {
            this.listeners.addIfAbsent(listener);
        }

        public void removeListener(TransportConnectionListener listener) {
            this.listeners.remove(listener);
        }
    }

    @FunctionalInterface
    public static interface ConnectionValidator {
        public void validate(TransportConnection var1, ConnectionProfile var2, ActionListener<Void> var3);
    }
}

