/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.Version;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.transport.NetworkExceptionHelper;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.ReleasableBytesStreamOutput;
import io.skylite.core.common.network.CloseableChannel;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.OutboundMessage;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.transport.StatsTracker;
import io.skylite.core.transport.TcpChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportLogger;
import io.skylite.core.transport.TransportMessageListener;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponse;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

final class OutboundHandler {
    private static final Logger logger = LogManager.getLogger(OutboundHandler.class);
    private final String nodeName;
    private final Version version;
    private final String[] features;
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    OutboundHandler(String nodeName, Version version, String[] features, StatsTracker statsTracker, ThreadPool threadPool, BigArrays bigArrays) {
        this.nodeName = nodeName;
        this.version = version;
        this.features = features;
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
    }

    void sendBytes(TcpChannel channel, BytesReference bytes, ActionListener<Void> listener) {
        SendContext sendContext = new SendContext(channel, (CheckedSupplier<BytesReference, IOException>)((CheckedSupplier)() -> bytes), listener);
        try {
            this.internalSend(channel, sendContext);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    void sendRequest(DiscoveryNode node, TcpChannel channel, long requestId, String action, TransportRequest request, TransportRequestOptions options, Version channelVersion, boolean compressRequest, boolean isHandshake) throws IOException, TransportException {
        Version version = Version.min(this.version, channelVersion);
        OutboundMessage.Request message = new OutboundMessage.Request(this.threadPool.getThreadContext(), this.features, request, version, action, requestId, isHandshake, compressRequest);
        ActionListener listener = ActionListenerHelper.wrap(() -> this.messageListener.onRequestSent(node, requestId, action, request, options));
        this.sendMessage(channel, message, listener);
    }

    void sendResponse(Version nodeVersion, Set<String> features, TcpChannel channel, long requestId, String action, TransportResponse response, boolean compress, boolean isHandshake) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        OutboundMessage.Response message = new OutboundMessage.Response(this.threadPool.getThreadContext(), features, response, version, requestId, isHandshake, compress);
        ActionListener listener = ActionListenerHelper.wrap(() -> this.messageListener.onResponseSent(requestId, action, response));
        this.sendMessage(channel, message, listener);
    }

    void sendErrorResponse(Version<?> nodeVersion, Set<String> features, TcpChannel channel, long requestId, String action, Exception error) throws IOException {
        Version<?> version = Version.min(this.version, nodeVersion);
        TransportAddress address = new TransportAddress(channel.getLocalAddress());
        RemoteTransportException tx = new RemoteTransportException(this.nodeName, address, action, error);
        OutboundMessage.Response message = new OutboundMessage.Response(this.threadPool.getThreadContext(), features, tx, version, requestId, false, false);
        ActionListener listener = ActionListenerHelper.wrap(() -> this.messageListener.onResponseSent(requestId, action, error));
        this.sendMessage(channel, message, listener);
    }

    private void sendMessage(TcpChannel channel, OutboundMessage networkMessage, ActionListener<Void> listener) throws IOException {
        MessageSerializer serializer = new MessageSerializer(networkMessage, this.bigArrays);
        SendContext sendContext = new SendContext(channel, serializer, listener, serializer);
        this.internalSend(channel, sendContext);
    }

    private void internalSend(TcpChannel channel, SendContext sendContext) throws IOException {
        channel.getChannelStats().markAccessed(this.threadPool.relativeTimeInMillis());
        BytesReference reference = sendContext.get();
        try (ThreadContext.StoredContext existing = this.threadPool.getThreadContext().stashContext();){
            channel.sendMessage(reference, (ActionListener<Void>)sendContext);
        }
        catch (RuntimeException ex) {
            sendContext.onFailure(ex);
            CloseableChannel.closeChannel(channel);
            throw ex;
        }
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    private class SendContext
    extends NotifyOnceListener<Void>
    implements CheckedSupplier<BytesReference, IOException> {
        private final TcpChannel channel;
        private final CheckedSupplier<BytesReference, IOException> messageSupplier;
        private final ActionListener<Void> listener;
        private final Releasable optionalReleasable;
        private long messageSize = -1L;

        private SendContext(TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener) {
            this(channel, messageSupplier, listener, null);
        }

        private SendContext(TcpChannel channel, CheckedSupplier<BytesReference, IOException> messageSupplier, ActionListener<Void> listener, Releasable optionalReleasable) {
            this.channel = channel;
            this.messageSupplier = messageSupplier;
            this.listener = listener;
            this.optionalReleasable = optionalReleasable;
        }

        public BytesReference get() throws IOException {
            try {
                BytesReference message = (BytesReference)this.messageSupplier.get();
                this.messageSize = message.length();
                TransportLogger.logOutboundMessage(this.channel, message);
                return message;
            }
            catch (Exception e) {
                this.onFailure(e);
                throw e;
            }
        }

        protected void innerOnResponse(Void v) {
            assert (this.messageSize != -1L) : "If onResponse is being called, the message should have been serialized";
            OutboundHandler.this.statsTracker.markBytesWritten(this.messageSize);
            this.closeAndCallback(() -> this.listener.onResponse((Object)v));
        }

        protected void innerOnFailure(Exception e) {
            if (NetworkExceptionHelper.isCloseConnectionException((Throwable)e)) {
                logger.debug(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            } else {
                logger.warn(() -> new ParameterizedMessage("send message failed [channel: {}]", (Object)this.channel), (Throwable)e);
            }
            this.closeAndCallback(() -> this.listener.onFailure(e));
        }

        private void closeAndCallback(Runnable runnable) {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = this.optionalReleasable;
            releasableArray[1] = runnable::run;
            Releasables.close((Releasable[])releasableArray);
        }
    }

    private static class MessageSerializer
    implements CheckedSupplier<BytesReference, IOException>,
    Releasable {
        private final OutboundMessage message;
        private final BigArrays bigArrays;
        private volatile ReleasableBytesStreamOutput bytesStreamOutput;

        private MessageSerializer(OutboundMessage message, BigArrays bigArrays) {
            this.message = message;
            this.bigArrays = bigArrays;
        }

        public BytesReference get() throws IOException {
            this.bytesStreamOutput = new ReleasableBytesStreamOutput(this.bigArrays);
            return this.message.serialize(this.bytesStreamOutput);
        }

        public void close() {
            IOUtils.closeWhileHandlingException((Closeable)this.bytesStreamOutput);
        }
    }
}

