/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.client.support.AbstractClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.RemoteClusterAwareRequest;
import io.skylite.core.transport.RemoteClusterService;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;

final class RemoteClusterAwareClient
extends AbstractClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;

    RemoteClusterAwareClient(Settings settings, ThreadPool threadPool, TransportService service, String clusterAlias) {
        super(settings, threadPool);
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListenerHelper.wrap(v -> {
            TransportConnection connection;
            if (request instanceof RemoteClusterAwareRequest) {
                DiscoveryNode preferredTargetNode = ((RemoteClusterAwareRequest)((Object)request)).getPreferredTargetNode();
                connection = this.remoteClusterService.getConnection(preferredTargetNode, this.clusterAlias);
            } else {
                connection = this.remoteClusterService.getConnection(this.clusterAlias);
            }
            this.service.sendRequest(connection, action.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(listener, action.getResponseReader()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void close() {
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }
}

