/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.OriginalIndices;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.NodeRole;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.NoSuchRemoteClusterException;
import io.skylite.core.transport.RemoteClusterAware;
import io.skylite.core.transport.RemoteClusterAwareClient;
import io.skylite.core.transport.RemoteClusterConnection;
import io.skylite.core.transport.RemoteConnectionInfo;
import io.skylite.core.transport.RemoteConnectionStrategy;
import io.skylite.core.transport.TransportConnection;
import io.skylite.core.transport.TransportService;
import io.skylite.core.transport.TransportSettings;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RemoteClusterService
extends RemoteClusterAware
implements Closeable {
    private final Logger logger = LogManager.getLogger(RemoteClusterService.class);
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("cluster.remote.", "skip_unavailable", (ns, key) -> Setting.boolSetting(key, false, new RemoteConnectionEnabled<Boolean>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> REMOTE_CLUSTER_PING_SCHEDULE = Setting.affixKeySetting("cluster.remote.", "transport.ping_schedule", (ns, key) -> Setting.timeSetting(key, TransportSettings.PING_SCHEDULE, new RemoteConnectionEnabled<TimeValue>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_COMPRESS = Setting.affixKeySetting("cluster.remote.", "transport.compress", (ns, key) -> Setting.boolSetting(key, TransportSettings.TRANSPORT_COMPRESS, new RemoteConnectionEnabled<Boolean>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private final boolean enabled;
    private final TransportService transportService;
    private final Map<String, RemoteClusterConnection> remoteClusters = ConcurrentCollections.newConcurrentMap();

    public boolean isEnabled() {
        return this.enabled;
    }

    RemoteClusterService(Settings settings, TransportService transportService) {
        super(settings);
        this.enabled = DiscoveryNode.isRemoteClusterClient(settings);
        this.transportService = transportService;
    }

    public boolean isCrossClusterSearchEnabled() {
        return !this.remoteClusters.isEmpty();
    }

    boolean isRemoteNodeConnected(String remoteCluster, DiscoveryNode node) {
        return this.remoteClusters.get(remoteCluster).isNodeConnected(node);
    }

    public Map<String, OriginalIndices> groupIndices(IndicesOptions indicesOptions, String[] indices, Predicate<String> indexExists) {
        HashMap<String, OriginalIndices> originalIndicesMap = new HashMap<String, OriginalIndices>();
        if (this.isCrossClusterSearchEnabled()) {
            Map<String, List<String>> groupedIndices = this.groupClusterIndices(this.getRemoteClusterNames(), indices, indexExists);
            if (groupedIndices.isEmpty()) {
                originalIndicesMap.put("", new OriginalIndices(Strings.EMPTY_ARRAY, indicesOptions));
            } else {
                for (Map.Entry<String, List<String>> entry : groupedIndices.entrySet()) {
                    String clusterAlias = entry.getKey();
                    List<String> originalIndices = entry.getValue();
                    originalIndicesMap.put(clusterAlias, new OriginalIndices(originalIndices.toArray(new String[0]), indicesOptions));
                }
            }
        } else {
            originalIndicesMap.put("", new OriginalIndices(indices, indicesOptions));
        }
        return originalIndicesMap;
    }

    boolean isRemoteClusterRegistered(String clusterName) {
        return this.remoteClusters.containsKey(clusterName);
    }

    public Set<String> getRegisteredRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    public TransportConnection getConnection(DiscoveryNode node, String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection(node);
    }

    void ensureConnected(String clusterAlias, ActionListener<Void> listener) {
        this.getRemoteClusterConnection(clusterAlias).ensureConnected(listener);
    }

    public boolean isSkipUnavailable(String clusterAlias) {
        return this.getRemoteClusterConnection(clusterAlias).isSkipUnavailable();
    }

    public TransportConnection getConnection(String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection();
    }

    RemoteClusterConnection getRemoteClusterConnection(String cluster) {
        if (!this.enabled) {
            throw new IllegalArgumentException("this node does not have the " + NodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role");
        }
        RemoteClusterConnection connection = this.remoteClusters.get(cluster);
        if (connection == null) {
            throw new NoSuchRemoteClusterException(cluster);
        }
        return connection;
    }

    Set<String> getRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    @Override
    public void listenForUpdates(ClusterSettings clusterSettings) {
        super.listenForUpdates(clusterSettings);
        clusterSettings.addAffixUpdateConsumer(REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::updateSkipUnavailable, (alias, value) -> {});
    }

    private synchronized void updateSkipUnavailable(String clusterAlias, Boolean skipUnavailable) {
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (remote != null) {
            remote.updateSkipUnavailable(skipUnavailable);
        }
    }

    @Override
    protected void updateRemoteCluster(String clusterAlias, Settings settings) {
        CountDownLatch latch = new CountDownLatch(1);
        this.updateRemoteCluster(clusterAlias, settings, ActionListenerHelper.wrap(latch::countDown));
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                this.logger.warn("failed to connect to new remote cluster {} within {}", (Object)clusterAlias, (Object)TimeValue.timeValueSeconds((long)10L));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized void updateRemoteCluster(String clusterAlias, Settings newSettings, ActionListener<Void> listener) {
        if ("".equals(clusterAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (!RemoteConnectionStrategy.isConnectionEnabled(clusterAlias, newSettings)) {
            try {
                IOUtils.close((Closeable)remote);
            }
            catch (IOException e) {
                this.logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
            }
            this.remoteClusters.remove(clusterAlias);
            listener.onResponse(null);
            return;
        }
        if (remote == null) {
            Settings finalSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
            remote = new RemoteClusterConnection(finalSettings, clusterAlias, this.transportService);
            this.remoteClusters.put(clusterAlias, remote);
            remote.ensureConnected(listener);
        } else if (remote.shouldRebuildConnection(newSettings)) {
            try {
                IOUtils.close((Closeable)remote);
            }
            catch (IOException e) {
                this.logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
            }
            this.remoteClusters.remove(clusterAlias);
            Settings finalSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
            remote = new RemoteClusterConnection(finalSettings, clusterAlias, this.transportService);
            this.remoteClusters.put(clusterAlias, remote);
            remote.ensureConnected(listener);
        } else {
            listener.onResponse(null);
        }
    }

    void initializeRemoteClusters(ActionListener<Void> listener) {
        Set<String> enabledClusters = RemoteClusterAware.getEnabledRemoteClusters(this.settings);
        if (enabledClusters.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        GroupedActionListener<Void> groupListener = new GroupedActionListener<Void>(ActionListenerHelper.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)), enabledClusters.size());
        for (String clusterAlias : enabledClusters) {
            this.updateRemoteCluster(clusterAlias, this.settings, groupListener);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.remoteClusters.values());
    }

    public Stream<RemoteConnectionInfo> getRemoteConnectionInfos() {
        return this.remoteClusters.values().stream().map(RemoteClusterConnection::getConnectionInfo);
    }

    public void collectNodes(Set<String> clusters, final ActionListener<BiFunction<String, String, DiscoveryNode>> listener) {
        if (!this.enabled) {
            throw new IllegalArgumentException("this node does not have the " + NodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role");
        }
        Map<String, RemoteClusterConnection> remoteClusters = this.remoteClusters;
        for (String cluster : clusters) {
            if (remoteClusters.containsKey(cluster)) continue;
            listener.onFailure((Exception)new NoSuchRemoteClusterException(cluster));
            return;
        }
        final HashMap clusterMap = new HashMap();
        final CountDown countDown = new CountDown(clusters.size());
        final Function<String, DiscoveryNode> nullFunction = s -> null;
        for (final String cluster : clusters) {
            RemoteClusterConnection connection = remoteClusters.get(cluster);
            connection.collectNodes(new ActionListener<Function<String, DiscoveryNode>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(Function<String, DiscoveryNode> nodeLookup) {
                    Map map = clusterMap;
                    synchronized (map) {
                        clusterMap.put(cluster, nodeLookup);
                    }
                    if (countDown.countDown()) {
                        listener.onResponse((clusterAlias, nodeId) -> (DiscoveryNode)clusterMap.getOrDefault(clusterAlias, nullFunction).apply(nodeId));
                    }
                }

                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    public Client getRemoteClusterClient(ThreadPool threadPool, String clusterAlias) {
        if (!this.transportService.getRemoteClusterService().isEnabled()) {
            throw new IllegalArgumentException("this node does not have the " + NodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role");
        }
        if (!this.transportService.getRemoteClusterService().getRemoteClusterNames().contains(clusterAlias)) {
            throw new NoSuchRemoteClusterException(clusterAlias);
        }
        return new RemoteClusterAwareClient(this.settings, threadPool, this.transportService, clusterAlias);
    }

    Collection<RemoteClusterConnection> getConnections() {
        return this.remoteClusters.values();
    }

    private static class RemoteConnectionEnabled<T>
    implements Setting.Validator<T> {
        private final String clusterAlias;
        private final String key;

        private RemoteConnectionEnabled(String clusterAlias, String key) {
            this.clusterAlias = clusterAlias;
            this.key = key;
        }

        @Override
        public void validate(T value) {
        }

        @Override
        public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
            if (isPresent && !RemoteConnectionStrategy.isConnectionEnabled(this.clusterAlias, settings)) {
                throw new IllegalArgumentException("Cannot configure setting [" + this.key + "] if remote cluster is not enabled.");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return Stream.concat(Stream.of(RemoteConnectionStrategy.REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.clusterAlias)), this.settingsStream()).iterator();
        }

        private Stream<Setting<?>> settingsStream() {
            return Arrays.stream(RemoteConnectionStrategy.ConnectionStrategy.values()).flatMap(strategy -> strategy.getEnablementSettings().get()).map(as -> as.getConcreteSettingForNamespace(this.clusterAlias));
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(REMOTE_CLUSTER_SKIP_UNAVAILABLE, REMOTE_CLUSTER_PING_SCHEDULE, REMOTE_CLUSTER_COMPRESS);
        }
    }
}

