/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.transport.RemoteConnectionStrategy;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public final class RemoteConnectionInfo
implements ToXContentFragment,
Writeable {
    final ModeInfo modeInfo;
    final TimeValue initialConnectionTimeout;
    final String clusterAlias;
    final boolean skipUnavailable;

    public RemoteConnectionInfo(String clusterAlias, ModeInfo modeInfo, TimeValue initialConnectionTimeout, boolean skipUnavailable) {
        this.clusterAlias = clusterAlias;
        this.modeInfo = modeInfo;
        this.initialConnectionTimeout = initialConnectionTimeout;
        this.skipUnavailable = skipUnavailable;
    }

    public RemoteConnectionInfo(StreamInput input) throws IOException {
        RemoteConnectionStrategy.ConnectionStrategy mode = input.readEnum(RemoteConnectionStrategy.ConnectionStrategy.class);
        this.modeInfo = mode.getReader().read(input);
        this.initialConnectionTimeout = input.readTimeValue();
        this.clusterAlias = input.readString();
        this.skipUnavailable = input.readBoolean();
    }

    public boolean isConnected() {
        return this.modeInfo.isConnected();
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ModeInfo getModeInfo() {
        return this.modeInfo;
    }

    public TimeValue getInitialConnectionTimeout() {
        return this.initialConnectionTimeout;
    }

    public boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.modeInfo.modeType());
        this.modeInfo.writeTo(out);
        out.writeTimeValue(this.initialConnectionTimeout);
        out.writeString(this.clusterAlias);
        out.writeBoolean(this.skipUnavailable);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.clusterAlias);
        builder.field("connected", this.modeInfo.isConnected());
        builder.field("mode", this.modeInfo.modeName());
        this.modeInfo.toXContent(builder, params);
        builder.field("initial_connect_timeout", (Object)this.initialConnectionTimeout);
        builder.field("skip_unavailable", this.skipUnavailable);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.skipUnavailable == that.skipUnavailable && Objects.equals(this.modeInfo, that.modeInfo) && Objects.equals(this.initialConnectionTimeout, that.initialConnectionTimeout) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.modeInfo, this.initialConnectionTimeout, this.clusterAlias, this.skipUnavailable);
    }

    public static interface ModeInfo
    extends ToXContentFragment,
    Writeable {
        public boolean isConnected();

        public String modeName();

        public RemoteConnectionStrategy.ConnectionStrategy modeType();
    }
}

