/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.network.CloseableChannel;
import java.net.InetSocketAddress;
import java.util.Optional;

public interface TcpChannel
extends CloseableChannel {
    public boolean isServerChannel();

    public String getProfile();

    public InetSocketAddress getLocalAddress();

    public InetSocketAddress getRemoteAddress();

    public void sendMessage(BytesReference var1, ActionListener<Void> var2);

    public void addConnectListener(ActionListener<Void> var1);

    public ChannelStats getChannelStats();

    default public <T> Optional<T> get(String name, Class<T> clazz) {
        return Optional.empty();
    }

    public static class ChannelStats {
        private volatile long lastAccessedTime = TimeValue.nsecToMSec((long)System.nanoTime());

        public void markAccessed(long relativeMillisTime) {
            this.lastAccessedTime = relativeMillisTime;
        }

        public long lastAccessedTime() {
            return this.lastAccessedTime;
        }
    }
}

