/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.transport;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportResponse;
import java.io.IOException;
import java.util.function.Function;

public interface TransportResponseHandler<T extends TransportResponse>
extends Writeable.Reader<T> {
    public void handleResponse(T var1);

    public void handleException(TransportException var1);

    public String executor();

    default public void handleRejection(Exception exp) {
    }

    default public <Q extends TransportResponse> TransportResponseHandler<Q> wrap(final Function<Q, T> converter, final Writeable.Reader<Q> reader) {
        final TransportResponseHandler self = this;
        return new TransportResponseHandler<Q>(){

            @Override
            public void handleResponse(Q response) {
                self.handleResponse((TransportResponse)converter.apply(response));
            }

            @Override
            public void handleException(TransportException exp) {
                self.handleException(exp);
            }

            @Override
            public String executor() {
                return self.executor();
            }

            @Override
            public Q read(StreamInput in) throws IOException {
                return (TransportResponse)reader.read(in);
            }
        };
    }
}

