/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.xcontent;

import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.mapper.ParseContext;
import io.skylite.core.xcontent.AbstractXContentParser;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;

public class JsonToStringXContentParser
extends AbstractXContentParser {
    private final String fieldTypeName;
    private XContentParser parser;
    private ArrayList<String> valueList = new ArrayList();
    private ArrayList<String> valueAndPathList = new ArrayList();
    private ArrayList<String> keyList = new ArrayList();
    private XContentBuilder builder = XContentBuilder.builder(MediaTypeRegistry.JSON.xContent());
    private ParseContext parseContext;
    private NamedXContentRegistry xContentRegistry;
    private DeprecationHandler deprecationHandler;
    private static final String VALUE_AND_PATH_SUFFIX = "._valueAndPath";
    private static final String VALUE_SUFFIX = "._value";
    private static final String DOT_SYMBOL = ".";
    private static final String EQUAL_SYMBOL = "=";

    public JsonToStringXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, ParseContext parseContext, String fieldTypeName) throws IOException {
        super(xContentRegistry, deprecationHandler);
        this.parseContext = parseContext;
        this.deprecationHandler = deprecationHandler;
        this.xContentRegistry = xContentRegistry;
        this.parser = parseContext.parser();
        this.fieldTypeName = fieldTypeName;
    }

    public XContentParser parseObject() throws IOException {
        this.builder.startObject();
        StringBuilder path = new StringBuilder(this.fieldTypeName);
        this.parseToken(path, null);
        this.builder.field(this.fieldTypeName, this.keyList);
        this.builder.field(this.fieldTypeName + VALUE_SUFFIX, this.valueList);
        this.builder.field(this.fieldTypeName + VALUE_AND_PATH_SUFFIX, this.valueAndPathList);
        this.builder.endObject();
        String jString = XContentHelper.convertToJson(BytesReference.bytes(this.builder), false, MediaTypeRegistry.JSON);
        return MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, this.deprecationHandler, String.valueOf(jString));
    }

    private void parseToken(StringBuilder path, String currentFieldName) throws IOException {
        while (this.parser.nextToken() != XContentParser.Token.END_OBJECT) {
            int dotIndex;
            if (this.parser.currentName() != null) {
                currentFieldName = this.parser.currentName();
            }
            StringBuilder parsedFields = new StringBuilder();
            if (this.parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                path.append(DOT_SYMBOL + currentFieldName);
                this.keyList.add(currentFieldName);
                continue;
            }
            if (this.parser.currentToken() == XContentParser.Token.START_ARRAY) {
                this.parseToken(path, currentFieldName);
                break;
            }
            if (this.parser.currentToken() == XContentParser.Token.END_ARRAY) continue;
            if (this.parser.currentToken() == XContentParser.Token.START_OBJECT) {
                this.parseToken(path, currentFieldName);
                dotIndex = path.lastIndexOf(DOT_SYMBOL);
                if (dotIndex == -1) continue;
                path.delete(dotIndex, path.length());
                continue;
            }
            if (!path.toString().contains(currentFieldName)) {
                path.append(DOT_SYMBOL + currentFieldName);
            }
            this.parseValue(parsedFields);
            this.valueList.add(parsedFields.toString());
            this.valueAndPathList.add(String.valueOf(path) + EQUAL_SYMBOL + String.valueOf(parsedFields));
            dotIndex = path.lastIndexOf(DOT_SYMBOL);
            if (dotIndex == -1) continue;
            path.delete(dotIndex, path.length());
        }
    }

    private void parseValue(StringBuilder parsedFields) throws IOException {
        switch (this.parser.currentToken()) {
            case VALUE_BOOLEAN: 
            case VALUE_NUMBER: 
            case VALUE_STRING: 
            case VALUE_NULL: {
                parsedFields.append(this.parser.textOrNull());
                break;
            }
            case FIELD_NAME: 
            case VALUE_EMBEDDED_OBJECT: 
            case END_ARRAY: 
            case START_ARRAY: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type [" + String.valueOf((Object)this.parser.currentToken()) + "]");
            }
        }
    }

    @Override
    public MediaType contentType() {
        return MediaTypeRegistry.JSON;
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        return this.parser.nextToken();
    }

    @Override
    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    @Override
    public XContentParser.Token currentToken() {
        return this.parser.currentToken();
    }

    @Override
    public String currentName() throws IOException {
        return this.parser.currentName();
    }

    @Override
    public String text() throws IOException {
        return this.parser.text();
    }

    @Override
    public CharBuffer charBuffer() throws IOException {
        return this.parser.charBuffer();
    }

    @Override
    public Object objectText() throws IOException {
        return this.parser.objectText();
    }

    @Override
    public Object objectBytes() throws IOException {
        return this.parser.objectBytes();
    }

    @Override
    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    @Override
    public char[] textCharacters() throws IOException {
        return this.parser.textCharacters();
    }

    @Override
    public int textLength() throws IOException {
        return this.parser.textLength();
    }

    @Override
    public int textOffset() throws IOException {
        return this.parser.textOffset();
    }

    @Override
    public Number numberValue() throws IOException {
        return this.parser.numberValue();
    }

    @Override
    public XContentParser.NumberType numberType() throws IOException {
        return this.parser.numberType();
    }

    @Override
    public byte[] binaryValue() throws IOException {
        return this.parser.binaryValue();
    }

    @Override
    public XContentLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    @Override
    protected boolean doBooleanValue() throws IOException {
        return this.parser.booleanValue();
    }

    @Override
    protected short doShortValue() throws IOException {
        return this.parser.shortValue();
    }

    @Override
    protected int doIntValue() throws IOException {
        return this.parser.intValue();
    }

    @Override
    protected long doLongValue() throws IOException {
        return this.parser.longValue();
    }

    @Override
    protected float doFloatValue() throws IOException {
        return this.parser.floatValue();
    }

    @Override
    protected double doDoubleValue() throws IOException {
        return this.parser.doubleValue();
    }

    @Override
    protected BigInteger doBigIntegerValue() throws IOException {
        return this.parser.bigIntegerValue();
    }

    @Override
    public boolean isClosed() {
        return this.parser.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }
}

