/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.xcontent;

import io.skylite.core.ParseField;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.XContentLocation;
import java.util.function.Supplier;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    public static final LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParseField.class);

    private LoggingDeprecationHandler() {
    }

    @Override
    public void usedDeprecatedName(String parserName, Supplier<XContentLocation> location, String usedName, String modernName) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + String.valueOf(location.get()) + "] ";
        deprecationLogger.deprecate(usedName + "_deprecated_name", "{}Deprecated field [{}] used, expected [{}] instead", prefix, usedName, modernName);
    }

    @Override
    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName, String replacedWith) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + String.valueOf(location.get()) + "] ";
        deprecationLogger.deprecate(usedName + "_deprecated_field", "{}Deprecated field [{}] used, replaced by [{}]", prefix, usedName, replacedWith);
    }

    @Override
    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + String.valueOf(location.get()) + "] ";
        deprecationLogger.deprecate(usedName + "_deprecated_field", "{}Deprecated field [{}] used, this field is unused and will be removed entirely", prefix, usedName);
    }
}

