/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.xcontent;

import io.skylite.SkyliteParseException;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.compress.Compressor;
import io.skylite.core.compress.CompressorRegistry;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParseException;
import io.skylite.core.xcontent.XContentParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class XContentHelper {
    private XContentHelper() {
    }

    @Deprecated
    public static BytesReference toXContent(ToXContent toXContent, MediaType mediaType, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(toXContent, mediaType, ToXContent.EMPTY_PARAMS, humanReadable);
    }

    public static BytesReference toXContent(ToXContent toXContent, MediaType mediaType, ToXContent.Params params, boolean humanReadable) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder(mediaType.xContent());){
            builder.humanReadable(humanReadable);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    @Deprecated
    public static Tuple<? extends MediaType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered) throws SkyliteParseException {
        return XContentHelper.convertToMap(bytes, ordered, null);
    }

    public static Tuple<? extends MediaType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, MediaType mediaType) throws SkyliteParseException {
        Tuple tuple;
        block12: {
            InputStream input;
            Compressor compressor = CompressorRegistry.compressor(bytes);
            if (compressor != null) {
                InputStream compressedStreamInput = compressor.threadLocalInputStream(bytes.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                input = compressedStreamInput;
            } else {
                if (bytes instanceof BytesArray) {
                    BytesArray arr = (BytesArray)bytes;
                    byte[] raw = arr.array();
                    int offset = arr.offset();
                    int length = arr.length();
                    MediaType contentType = mediaType != null ? mediaType : MediaTypeRegistry.mediaTypeFromBytes(raw, offset, length);
                    return new Tuple((Object)Objects.requireNonNull(contentType), XContentHelper.convertToMap(contentType.xContent(), raw, offset, length, ordered));
                }
                input = bytes.streamInput();
            }
            StreamInput stream = input;
            try {
                MediaType contentType = mediaType != null ? mediaType : MediaTypeRegistry.xContentType(stream);
                tuple = new Tuple((Object)Objects.requireNonNull(contentType), XContentHelper.convertToMap(contentType.xContent(), stream, ordered));
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SkyliteParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            ((InputStream)stream).close();
        }
        return tuple;
    }

    public static Map<String, Object> convertToMap(XContent xContent, String string, boolean ordered) throws SkyliteParseException {
        Map<String, Object> map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, string);
            try {
                Map<String, Object> map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SkyliteParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered) throws SkyliteParseException {
        Map<String, Object> map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, input);
            try {
                Map<String, Object> map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SkyliteParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, byte[] bytes, int offset, int length, boolean ordered) throws SkyliteParseException {
        Map<String, Object> map;
        block8: {
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, bytes, offset, length);
            try {
                Map<String, Object> map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SkyliteParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, BytesReference bytes) throws IOException {
        Compressor compressor = CompressorRegistry.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = null;
            try {
                compressedInput = compressor.threadLocalInputStream(bytes.streamInput());
                if (!compressedInput.markSupported()) {
                    compressedInput = new BufferedInputStream(compressedInput);
                }
                MediaType contentType = MediaTypeRegistry.xContentType(compressedInput);
                return contentType.xContent().createParser(xContentRegistry, deprecationHandler, compressedInput);
            }
            catch (Exception e) {
                if (compressedInput != null) {
                    compressedInput.close();
                }
                throw e;
            }
        }
        return MediaTypeRegistry.xContentType(bytes).xContent().createParser(xContentRegistry, deprecationHandler, bytes.streamInput());
    }

    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, BytesReference bytes, MediaType mediaType) throws IOException {
        Objects.requireNonNull(mediaType);
        Compressor compressor = CompressorRegistry.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = null;
            try {
                compressedInput = compressor.threadLocalInputStream(bytes.streamInput());
                if (!compressedInput.markSupported()) {
                    compressedInput = new BufferedInputStream(compressedInput);
                }
                return mediaType.xContent().createParser(xContentRegistry, deprecationHandler, compressedInput);
            }
            catch (Exception e) {
                if (compressedInput != null) {
                    compressedInput.close();
                }
                throw e;
            }
        }
        if (bytes instanceof BytesArray) {
            BytesArray array = (BytesArray)bytes;
            return mediaType.xContent().createParser(xContentRegistry, deprecationHandler, array.array(), array.offset(), array.length());
        }
        return mediaType.xContent().createParser(xContentRegistry, deprecationHandler, bytes.streamInput());
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false);
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, prettyPrint, MediaTypeRegistry.xContent(bytes.toBytesRef().bytes));
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, MediaType mediaType) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false, mediaType);
    }

    public static String stripWhitespace(String json) throws IOException {
        return XContentHelper.convertToJson((BytesReference)new BytesArray(json), true, MediaTypeRegistry.JSON);
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint, MediaType mediaType) throws IOException {
        Objects.requireNonNull(mediaType);
        if (mediaType == MediaTypeRegistry.JSON && !reformatJson) {
            return bytes.utf8ToString();
        }
        if (bytes instanceof BytesArray) {
            BytesArray array = (BytesArray)bytes;
            try (XContentParser parser = mediaType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, array.array(), array.offset(), array.length());){
                String string = XContentHelper.toJsonString(prettyPrint, parser);
                return string;
            }
        }
        try (StreamInput stream = bytes.streamInput();){
            String string;
            block20: {
                XContentParser parser = mediaType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);
                try {
                    string = XContentHelper.toJsonString(prettyPrint, parser);
                    if (parser == null) break block20;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
    }

    private static String toJsonString(boolean prettyPrint, XContentParser parser) throws IOException {
        parser.nextToken();
        XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder();
        if (prettyPrint) {
            builder.prettyPrint();
        }
        builder.copyCurrentStructure(parser);
        return builder.toString();
    }

    public static boolean update(Map<String, Object> source, Map<String, Object> changes, boolean checkUpdatesAreUnequal) {
        boolean modified = false;
        for (Map.Entry<String, Object> changesEntry : changes.entrySet()) {
            if (!source.containsKey(changesEntry.getKey())) {
                source.put(changesEntry.getKey(), changesEntry.getValue());
                modified = true;
                continue;
            }
            Object old = source.get(changesEntry.getKey());
            if (old instanceof Map && changesEntry.getValue() instanceof Map) {
                modified |= XContentHelper.update((Map)source.get(changesEntry.getKey()), (Map)changesEntry.getValue(), checkUpdatesAreUnequal && !modified);
                continue;
            }
            source.put(changesEntry.getKey(), changesEntry.getValue());
            if (modified) continue;
            if (!checkUpdatesAreUnequal) {
                modified = true;
                continue;
            }
            modified = !Objects.equals(old, changesEntry.getValue());
        }
        return modified;
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            List defaultList = (List)defaultEntry.getValue();
            List contentList = (List)content.get(defaultEntry.getKey());
            ArrayList mergedList = new ArrayList();
            if (XContentHelper.allListValuesAreMapsOfOne(defaultList) && XContentHelper.allListValuesAreMapsOfOne(contentList)) {
                Map.Entry entry;
                Map map;
                LinkedHashMap<String, Map> processed = new LinkedHashMap<String, Map>();
                for (Object o : contentList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    processed.put((String)entry.getKey(), map);
                }
                for (Object o : defaultList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    if (processed.containsKey(entry.getKey())) {
                        XContentHelper.mergeDefaults((Map)processed.get(entry.getKey()), map);
                        continue;
                    }
                    processed.put((String)entry.getKey(), map);
                }
                for (Map map2 : processed.values()) {
                    mergedList.add(map2);
                }
            } else {
                mergedList.addAll(defaultList);
                for (Object o : contentList) {
                    if (mergedList.contains(o)) continue;
                    mergedList.add(o);
                }
            }
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static void writeRawField(String field, BytesReference source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Compressor compressor = CompressorRegistry.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream(source.streamInput());){
                builder.rawField(field, compressedStreamInput);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, stream);
        }
    }

    public static void writeRawField(String field, BytesReference source, MediaType xContentType, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorRegistry.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream(source.streamInput());){
                builder.rawField(field, compressedStreamInput, xContentType);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, stream, xContentType);
        }
    }

    public static BytesReference childBytes(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + String.valueOf((Object)parser.currentToken()) + "]");
        }
        XContentBuilder builder = XContentBuilder.builder(parser.contentType().xContent());
        builder.copyCurrentStructure(parser);
        return BytesReference.bytes(builder);
    }
}

