/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.xcontent;

import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Consumer;

public final class XContentParserUtils {
    private XContentParserUtils() {
    }

    public static void ensureFieldName(XContentParser parser, XContentParser.Token token, String fieldName) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String currentName = parser.currentName();
        if (!currentName.equals(fieldName)) {
            String message = "Failed to parse object: expecting field with name [%s] but found [%s]";
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, message, fieldName, currentName), new Object[0]);
        }
    }

    public static void throwUnknownField(String field, XContentLocation location) {
        String message = "Failed to parse object: unknown field [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, field), new Object[0]);
    }

    public static void throwUnknownToken(XContentParser.Token token, XContentLocation location) {
        String message = "Failed to parse object: unexpected token [%s] found";
        throw new ParsingException(location, String.format(Locale.ROOT, message, new Object[]{token}), new Object[0]);
    }

    public static void ensureExpectedToken(XContentParser.Token expected, XContentParser.Token actual, XContentParser parser) {
        if (actual != expected) {
            throw XContentParserUtils.parsingException(parser, expected, actual);
        }
    }

    private static ParsingException parsingException(XContentParser parser, XContentParser.Token expected, XContentParser.Token actual) {
        return new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] but found [%s]", new Object[]{expected, actual}), new Object[0]);
    }

    public static Object parseFieldsValue(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        Object value = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            value = parser.text();
        } else if (token == XContentParser.Token.VALUE_NUMBER) {
            value = parser.numberValue();
        } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
            value = parser.booleanValue();
        } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            value = new BytesArray(parser.binaryValue());
        } else if (token == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (token == XContentParser.Token.START_OBJECT) {
            value = parser.mapOrdered();
        } else if (token == XContentParser.Token.START_ARRAY) {
            value = parser.listOrderedMap();
        } else {
            XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
        }
        return value;
    }

    public static <T> void parseTypedKeysObject(XContentParser parser, String delimiter, Class<T> objectClass, Consumer<T> consumer) throws IOException {
        String currentFieldName;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.currentToken() != XContentParser.Token.START_ARRAY) {
            XContentParserUtils.throwUnknownToken(parser.currentToken(), parser.getTokenLocation());
        }
        if (Strings.hasLength(currentFieldName = parser.currentName())) {
            int position = currentFieldName.indexOf(delimiter);
            if (position > 0) {
                String type = currentFieldName.substring(0, position);
                String name = currentFieldName.substring(position + 1);
                consumer.accept(parser.namedObject(objectClass, type, name));
                return;
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Failed to parse object: empty key", new Object[0]);
        }
        parser.skipChildren();
    }
}

