/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common;

import io.skylite.common.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExceptionsHelper {
    private ExceptionsHelper() {
    }

    public static boolean reThrowIfNotNull(@Nullable Throwable e) {
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return true;
    }

    public static <T extends Throwable> Optional<T> unwrapCausesAndSuppressed(Throwable cause, Predicate<Throwable> predicate) {
        if (predicate.test(cause)) {
            return Optional.of(cause);
        }
        LinkedList<Throwable> queue = new LinkedList<Throwable>();
        queue.add(cause);
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        while (!queue.isEmpty()) {
            Throwable current = (Throwable)queue.remove();
            if (!seen.add(current)) continue;
            if (predicate.test(current)) {
                return Optional.of(current);
            }
            Collections.addAll(queue, current.getSuppressed());
            if (current.getCause() == null) continue;
            queue.add(current.getCause());
        }
        return Optional.empty();
    }

    public static Optional<Error> maybeError(Throwable cause) {
        return ExceptionsHelper.unwrapCausesAndSuppressed(cause, t -> t instanceof Error);
    }

    public static String stackTrace(Throwable e) {
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(printWriter);
        return stackTraceStringWriter.toString();
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        return Arrays.stream(stackTrace).skip(1L).map(e -> "\tat " + String.valueOf(e)).collect(Collectors.joining("\n"));
    }

    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw main;
        }
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }
}

