/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;

public class TokenBucket {
    private final LongSupplier clock;
    private final double rate;
    private final double burst;
    private final AtomicReference<State> state;

    public TokenBucket(LongSupplier clock, double rate, double burst) {
        this(clock, rate, burst, burst);
    }

    public TokenBucket(LongSupplier clock, double rate, double burst, double initialTokens) {
        if (rate <= 0.0) {
            throw new IllegalArgumentException("rate must be greater than zero");
        }
        if (burst <= 0.0) {
            throw new IllegalArgumentException("burst must be greater than zero");
        }
        this.clock = clock;
        this.rate = rate;
        this.burst = burst;
        this.state = new AtomicReference<State>(new State(Math.min(initialTokens, burst), clock.getAsLong()));
    }

    public boolean request(double n) {
        long now;
        double incr;
        State updatedState;
        State currentState;
        if (n <= 0.0) {
            throw new IllegalArgumentException("requested tokens must be greater than zero");
        }
        while (!this.state.compareAndSet(currentState = this.state.get(), updatedState = new State(Math.min(currentState.tokens + (incr = (double)((now = this.clock.getAsLong()) - currentState.lastRefilledAt) * this.rate), this.burst), now))) {
        }
        do {
            currentState = this.state.get();
            if (!(currentState.tokens < n)) continue;
            return false;
        } while (!this.state.compareAndSet(currentState, updatedState = new State(currentState.tokens - n, currentState.lastRefilledAt)));
        return true;
    }

    public boolean request() {
        return this.request(1.0);
    }

    private static class State {
        final double tokens;
        final long lastRefilledAt;

        public State(double tokens, long lastRefilledAt) {
            this.tokens = tokens;
            this.lastRefilledAt = lastRefilledAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Double.compare(state.tokens, this.tokens) == 0 && this.lastRefilledAt == state.lastRefilledAt;
        }

        public int hashCode() {
            return Objects.hash(this.tokens, this.lastRefilledAt);
        }
    }
}

