/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.action;

import io.skylite.common.CheckedConsumer;
import io.skylite.common.CheckedRunnable;
import io.skylite.common.action.NotifyOnceListener;
import io.skylite.common.annotation.PublicApi;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@PublicApi(since="1.0.0")
public interface ActionListener<Response> {
    public static <Response> ActionListener<Response> notifyOnce(final ActionListener<Response> delegate) {
        return new NotifyOnceListener<Response>(){

            @Override
            protected void innerOnResponse(Response response) {
                delegate.onResponse(response);
            }

            @Override
            protected void innerOnFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> BiConsumer<Response, Exception> toBiConsumer(ActionListener<Response> listener) {
        return (response, throwable) -> {
            if (throwable == null) {
                listener.onResponse(response);
            } else {
                listener.onFailure((Exception)throwable);
            }
        };
    }

    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }

    public static <Response> ActionListener<Response> runBefore(final ActionListener<Response> delegate, final CheckedRunnable<?> runBefore) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    delegate.onFailure(ex);
                    return;
                }
                delegate.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                delegate.onFailure(e);
            }
        };
    }
}

