/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.action;

import io.skylite.common.CheckedConsumer;
import io.skylite.common.CheckedRunnable;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.AbstractRunnable;

public abstract class ActionRunnable<Response>
extends AbstractRunnable {
    protected final ActionListener<Response> listener;

    public static <T> ActionRunnable<T> run(ActionListener<T> listener, final CheckedRunnable<Exception> runnable) {
        return new ActionRunnable<T>(listener){

            @Override
            public void doRun() throws Exception {
                runnable.run();
                this.listener.onResponse(null);
            }
        };
    }

    public static <T> ActionRunnable<T> supply(ActionListener<T> listener, CheckedSupplier<T, Exception> supplier) {
        return ActionRunnable.wrap(listener, l -> l.onResponse(supplier.get()));
    }

    public static <T> ActionRunnable<T> wrap(ActionListener<T> listener, final CheckedConsumer<ActionListener<T>, Exception> consumer) {
        return new ActionRunnable<T>(listener){

            @Override
            public void doRun() throws Exception {
                consumer.accept(this.listener);
            }
        };
    }

    public ActionRunnable(ActionListener<Response> listener) {
        this.listener = listener;
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }
}

