/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.telemetry.tracing;

import io.skylite.common.annotation.InternalApi;
import io.skylite.common.telemetry.tracing.Span;
import io.skylite.common.telemetry.tracing.SpanScope;
import io.skylite.common.telemetry.tracing.TracerContextStorage;
import java.util.Objects;

@InternalApi
class DefaultSpanScope
implements SpanScope {
    private final Span span;
    private final SpanScope previousSpanScope;
    private static final ThreadLocal<SpanScope> spanScopeThreadLocal = new ThreadLocal();
    private final TracerContextStorage<String, Span> tracerContextStorage;

    private DefaultSpanScope(Span span, SpanScope previousSpanScope, TracerContextStorage<String, Span> tracerContextStorage) {
        this.span = Objects.requireNonNull(span);
        this.previousSpanScope = previousSpanScope;
        this.tracerContextStorage = tracerContextStorage;
    }

    public static SpanScope create(Span span, TracerContextStorage<String, Span> tracerContextStorage) {
        SpanScope beforeSpanScope = spanScopeThreadLocal.get();
        DefaultSpanScope newSpanScope = new DefaultSpanScope(span, beforeSpanScope, tracerContextStorage);
        return newSpanScope;
    }

    @Override
    public void close() {
        this.detach();
    }

    @Override
    public SpanScope attach() {
        spanScopeThreadLocal.set(this);
        this.tracerContextStorage.put("current_span", this.span);
        return this;
    }

    private void detach() {
        spanScopeThreadLocal.set(this.previousSpanScope);
        if (this.previousSpanScope != null) {
            this.tracerContextStorage.put("current_span", this.previousSpanScope.getSpan());
        } else {
            this.tracerContextStorage.put("current_span", null);
        }
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    static SpanScope getCurrentSpanScope() {
        return spanScopeThreadLocal.get();
    }
}

