/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.telemetry.tracing.attributes;

import io.skylite.common.annotation.ExperimentalApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ExperimentalApi
public class Attributes {
    private final Map<String, Object> attributesMap;
    public static final Attributes EMPTY = new Attributes(Collections.emptyMap());

    public static Attributes create() {
        return new Attributes(new HashMap<String, Object>());
    }

    private Attributes(Map<String, Object> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Attributes addAttribute(String key, String value) {
        Objects.requireNonNull(value, "value cannot be null");
        this.attributesMap.put(key, value);
        return this;
    }

    public Attributes addAttribute(String key, long value) {
        this.attributesMap.put(key, value);
        return this;
    }

    public Attributes addAttribute(String key, double value) {
        this.attributesMap.put(key, value);
        return this;
    }

    public Attributes addAttribute(String key, boolean value) {
        this.attributesMap.put(key, value);
        return this;
    }

    public Map<String, ?> getAttributesMap() {
        return Collections.unmodifiableMap(this.attributesMap);
    }
}

