/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.transport;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class PortsRange {
    private final String portRange;

    public PortsRange(String portRange) {
        this.portRange = portRange;
    }

    public String getPortRangeString() {
        return this.portRange;
    }

    public int[] ports() throws NumberFormatException {
        ArrayList ports = new ArrayList();
        this.iterate(portNumber -> {
            ports.add(portNumber);
            return false;
        });
        return ports.stream().mapToInt(Integer::intValue).toArray();
    }

    public boolean iterate(PortCallback callback) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.portRange, ",");
        boolean success = false;
        while (st.hasMoreTokens() && !success) {
            String portToken = st.nextToken().trim();
            int index = portToken.indexOf(45);
            if (index == -1) {
                int portNumber = Integer.parseInt(portToken.trim());
                success = callback.onPortNumber(portNumber);
                if (!success) continue;
                break;
            }
            int startPort = Integer.parseInt(portToken.substring(0, index).trim());
            int endPort = Integer.parseInt(portToken.substring(index + 1).trim());
            if (endPort < startPort) {
                throw new IllegalArgumentException("Start port [" + startPort + "] must be greater than end port [" + endPort + "]");
            }
            for (int i = startPort; i <= endPort && !(success = callback.onPortNumber(i)); ++i) {
            }
        }
        return success;
    }

    public String toString() {
        return "PortsRange{portRange='" + this.portRange + "'}";
    }

    public static interface PortCallback {
        public boolean onPortNumber(int var1);
    }
}

